/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.cache.generator;

import java.lang.reflect.Method;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import vip.justlive.oxygen.cache.generator.KeyGenerator;
import vip.justlive.oxygen.core.exception.Exceptions;
import vip.justlive.oxygen.core.util.ClassUtils;
import vip.justlive.oxygen.core.util.MoreObjects;
import vip.justlive.oxygen.ioc.annotation.Bean;

@Bean
public class ArgsKeyGenerator
implements KeyGenerator {
    private static final Pattern ARGS_PATTERN = Pattern.compile("args\\[(\\d+)[]]");
    private static final Pattern FIELD_PATTERN = Pattern.compile("\\[([^\\[\\]]+)[]]");

    @Override
    public Object generate(Object target, Method method, Object ... params) {
        if (params.length != 2) {
            throw new IllegalArgumentException();
        }
        String key = params[0].toString();
        Object[] args = (Object[])params[1];
        return String.join((CharSequence)".", method.getDeclaringClass().getName(), method.getName(), MoreObjects.safeToString((Object)this.parse(key, args)));
    }

    private Object parse(String key, Object[] args) {
        Matcher matcher = ARGS_PATTERN.matcher(key);
        if (matcher.find()) {
            String source = matcher.group(0);
            int index = Integer.parseInt(matcher.group(1));
            if (index > args.length - 1) {
                throw Exceptions.fail((String)String.format("Cacheable.key[%s] illegal, out of bounds", key));
            }
            return this.parse(key.substring(source.length()), args[index]);
        }
        throw Exceptions.fail((String)String.format("Cacheable.key[%s] illegal", key));
    }

    private Object parse(String key, Object obj) {
        Matcher matcher = FIELD_PATTERN.matcher(key);
        int index = 0;
        Object value = obj;
        while (matcher.find(index)) {
            if (value == null) {
                return null;
            }
            String field = matcher.group(1);
            value = ClassUtils.getValue((Object)value, (String)field);
            index = matcher.end();
        }
        return value;
    }
}

