/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vip.justlive.oxygen.core.Plugin;
import vip.justlive.oxygen.core.config.ConfigFactory;
import vip.justlive.oxygen.core.exception.WrappedException;
import vip.justlive.oxygen.core.util.FileUtils;
import vip.justlive.oxygen.core.util.IoUtils;
import vip.justlive.oxygen.core.util.ServiceLoaderUtils;
import vip.justlive.oxygen.core.util.ThreadUtils;

public final class Bootstrap {
    private static final Logger log;
    private static final List<Plugin> PLUGINS;
    private static final AtomicBoolean STATE;
    private static final Thread SHUTDOWN_HOOK;
    private static final String VERSION;

    public static String version() {
        return VERSION;
    }

    public static void initConfig() {
        Bootstrap.initConfig("classpath*:config.properties", "classpath*:/config/*.properties");
    }

    public static void initConfig(String ... locations) {
        ConfigFactory.loadProperties(locations);
        String overridePath = ConfigFactory.getProperty("config.override.path");
        if (overridePath != null && overridePath.length() > 0) {
            ConfigFactory.loadProperties(overridePath.split(","));
        }
    }

    public static void addCustomPlugin(Plugin ... plugins) {
        if (STATE.get()) {
            throw new IllegalStateException("Bootstrap\u5df2\u542f\u52a8");
        }
        PLUGINS.addAll(Arrays.asList(plugins));
    }

    public static List<Plugin> enabledPlugins() {
        return Collections.unmodifiableList(PLUGINS);
    }

    public static void registerUncaughtExceptionHandler() {
        if (Thread.getDefaultUncaughtExceptionHandler() == null) {
            Thread.setDefaultUncaughtExceptionHandler(Bootstrap::handleException);
        }
    }

    public static void start() {
        if (STATE.compareAndSet(false, true)) {
            log.info("starting bootstrap ...");
            Bootstrap.registerUncaughtExceptionHandler();
            Bootstrap.initConfig();
            Bootstrap.addSystemPlugin();
            Bootstrap.initPlugins();
            Bootstrap.registerShutdownHook();
            log.info("bootstrap has started ! have fun");
        }
    }

    public static synchronized void close() {
        Bootstrap.doClose();
        Runtime.getRuntime().removeShutdownHook(SHUTDOWN_HOOK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sync() {
        if (!STATE.get() || Thread.currentThread().isInterrupted()) {
            return;
        }
        AtomicBoolean atomicBoolean = STATE;
        synchronized (atomicBoolean) {
            while (STATE.get()) {
                try {
                    STATE.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }
    }

    private static void addSystemPlugin() {
        PLUGINS.addAll(ServiceLoaderUtils.loadServices(Plugin.class));
    }

    private static void initPlugins() {
        Collections.sort(PLUGINS);
        PLUGINS.forEach(Plugin::start);
    }

    private static synchronized void registerShutdownHook() {
        Runtime.getRuntime().addShutdownHook(SHUTDOWN_HOOK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doClose() {
        log.info("closing bootstrap ...");
        PLUGINS.forEach(Plugin::stop);
        FileUtils.cleanTempBaseDir();
        STATE.set(false);
        AtomicBoolean atomicBoolean = STATE;
        synchronized (atomicBoolean) {
            STATE.notifyAll();
        }
        log.info("bootstrap closed ! bye bye");
    }

    private static void handleException(Thread thread, Throwable throwable) {
        if (throwable instanceof WrappedException) {
            throwable = ((WrappedException)throwable).getException();
        }
        log.error("thread [{}] uncaught exception", (Object)thread.getName(), (Object)throwable);
    }

    private Bootstrap() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        String version;
        log = LoggerFactory.getLogger(Bootstrap.class);
        PLUGINS = new ArrayList<Plugin>(8);
        STATE = new AtomicBoolean(false);
        try (InputStream in = Bootstrap.class.getResourceAsStream("/vip/justlive/oxygen/core/Version");){
            version = IoUtils.toString(in);
        }
        catch (Exception e) {
            version = "oxygen/unknown";
        }
        VERSION = version;
        SHUTDOWN_HOOK = ThreadUtils.defaultThreadFactory().newThread(Bootstrap::doClose);
    }
}

