/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.cache;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import vip.justlive.oxygen.core.cache.Cache;
import vip.justlive.oxygen.core.cache.CacheFactory;
import vip.justlive.oxygen.core.cache.ClassCacheFactory;
import vip.justlive.oxygen.core.util.MoreObjects;

public final class CacheStore {
    static final Map<String, Cache> CACHES = new ConcurrentHashMap<String, Cache>(4, 1.0f);
    private static final AtomicReference<CacheFactory> CACHE_FACTORY = new AtomicReference<ClassCacheFactory>(new ClassCacheFactory());

    static Cache createCache(String name) {
        return CACHE_FACTORY.get().create(name);
    }

    public static void setCacheFactory(CacheFactory cacheFactory) {
        MoreObjects.notNull(cacheFactory, "cache factory can not be null");
        if (CACHE_FACTORY.get() != cacheFactory) {
            CACHES.clear();
        }
        CACHE_FACTORY.set(cacheFactory);
    }

    private CacheStore() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

