/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.config;

import java.lang.reflect.Field;
import vip.justlive.oxygen.core.config.Ignore;
import vip.justlive.oxygen.core.config.Value;
import vip.justlive.oxygen.core.config.ValueConfig;
import vip.justlive.oxygen.core.convert.DefaultConverterService;
import vip.justlive.oxygen.core.exception.Exceptions;
import vip.justlive.oxygen.core.io.PropertySource;
import vip.justlive.oxygen.core.util.ClassUtils;
import vip.justlive.oxygen.core.util.Strings;

public class Binder {
    private final PropertySource source;

    public <T> T bind(Class<T> clazz) {
        return (T)this.bind((T)clazz, ".");
    }

    public <T> T bind(Class<T> clazz, String prefix) {
        boolean b;
        T obj;
        try {
            obj = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw Exceptions.wrap(e);
        }
        Class<?> actualClass = ClassUtils.getCglibActualClass(clazz);
        boolean bl = b = (prefix == null || ".".equals(prefix)) && actualClass.isAnnotationPresent(ValueConfig.class);
        if (b) {
            prefix = actualClass.getAnnotation(ValueConfig.class).value();
        }
        return clazz.cast(this.bind(obj, prefix));
    }

    public <T> T bind(T obj, String prefix) {
        if (!Strings.hasText(prefix) || ".".equals(prefix)) {
            prefix = null;
        }
        for (Field field : ClassUtils.getAllDeclaredFields(obj.getClass())) {
            this.bindField(obj, field, prefix);
        }
        return obj;
    }

    private void bindField(Object obj, Field field, String prefix) {
        if (field.isAnnotationPresent(Ignore.class)) {
            return;
        }
        String key = field.getName();
        boolean wrap = false;
        if (field.isAnnotationPresent(Value.class)) {
            key = field.getAnnotation(Value.class).value();
            wrap = true;
        } else if (prefix != null) {
            key = prefix + "." + key;
        }
        Object value = this.getProperty(key, field.getType(), wrap);
        if (value != null) {
            ClassUtils.setValue(obj, field, value);
            return;
        }
        if (!ClassUtils.isJavaInternalType(field.getType()) && this.source.containPrefix(key + ".")) {
            value = ClassUtils.getValue(obj, field);
            if (value == null) {
                value = this.bind((Object)field.getType(), key);
                ClassUtils.setValue(obj, field, value);
            } else {
                this.bind(value, key);
            }
        }
    }

    private Object getProperty(String key, Class<?> type, boolean wrap) {
        String value = wrap ? this.source.getPlaceholderProperty(key) : this.source.getProperty(key);
        if (value == null || value.getClass() == type) {
            return value;
        }
        return DefaultConverterService.sharedConverterService().convert(value, type);
    }

    public Binder(PropertySource source) {
        this.source = source;
    }
}

