/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.convert;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import vip.justlive.oxygen.core.convert.ArrayConverter;
import vip.justlive.oxygen.core.convert.Converter;
import vip.justlive.oxygen.core.convert.ConverterFactory;
import vip.justlive.oxygen.core.convert.ConverterRegistry;
import vip.justlive.oxygen.core.convert.ConverterService;
import vip.justlive.oxygen.core.convert.ConverterTypePair;
import vip.justlive.oxygen.core.convert.StringToArrayConverter;
import vip.justlive.oxygen.core.convert.StringToBooleanConverter;
import vip.justlive.oxygen.core.convert.StringToCharacterConverter;
import vip.justlive.oxygen.core.convert.StringToNumberConverterFactory;
import vip.justlive.oxygen.core.exception.Exceptions;
import vip.justlive.oxygen.core.util.MoreObjects;

public class DefaultConverterService
implements ConverterService,
ConverterRegistry {
    private static DefaultConverterService sharedConverterService;
    private final Map<ConverterTypePair, Converter<Object, Object>> converters = new HashMap<ConverterTypePair, Converter<Object, Object>>(8, 1.0f);
    private final Map<ConverterTypePair, ArrayConverter> arrayConverters = new HashMap<ConverterTypePair, ArrayConverter>(8, 1.0f);

    public DefaultConverterService() {
        this.addConverter(new StringToBooleanConverter()).addArrayConverter(new StringToArrayConverter(this)).addConverter(new StringToCharacterConverter()).addConverterFactory(new StringToNumberConverterFactory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DefaultConverterService sharedConverterService() {
        DefaultConverterService cs = sharedConverterService;
        if (cs != null) return sharedConverterService;
        Class<DefaultConverterService> clazz = DefaultConverterService.class;
        synchronized (DefaultConverterService.class) {
            cs = sharedConverterService;
            if (cs != null) return sharedConverterService;
            sharedConverterService = new DefaultConverterService();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sharedConverterService;
        }
    }

    @Override
    public ConverterRegistry addConverter(Converter<?, ?> converter) {
        MoreObjects.notNull(converter);
        for (ConverterTypePair pair : converter.pairs()) {
            this.converters.put(pair, converter);
        }
        return this;
    }

    @Override
    public ConverterRegistry addConverterFactory(ConverterFactory<?, ?> factory) {
        MoreObjects.notNull(factory).converters().forEach(this::addConverter);
        return this;
    }

    @Override
    public ConverterRegistry addArrayConverter(ArrayConverter converter) {
        MoreObjects.notNull(converter);
        this.arrayConverters.put(converter.pair(), converter);
        return this;
    }

    @Override
    public boolean canConverter(Class<?> source, Class<?> target) {
        return source.equals(target) || this.converters.containsKey(ConverterTypePair.create(source, target));
    }

    @Override
    public <T> T convert(Object source, Class<T> targetType) {
        ArrayConverter arrayConverter;
        if (source == null) {
            return null;
        }
        if (source.getClass().equals(targetType)) {
            return (T)source;
        }
        Converter<Object, Object> converter = this.converters.get(ConverterTypePair.create(source.getClass(), targetType));
        if (converter != null) {
            return (T)converter.convert(source);
        }
        if (targetType.isArray() && (arrayConverter = this.arrayConverters.get(ConverterTypePair.create(source.getClass(), Array.class))) != null) {
            return (T)arrayConverter.convert(source, source.getClass(), targetType);
        }
        throw Exceptions.fail(String.format("unsupported convert [%s] to [%s]", source, targetType));
    }
}

