/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.convert;

import java.lang.reflect.Array;
import vip.justlive.oxygen.core.convert.ArrayConverter;
import vip.justlive.oxygen.core.convert.ConverterService;
import vip.justlive.oxygen.core.convert.ConverterTypePair;
import vip.justlive.oxygen.core.exception.Exceptions;

public class StringToArrayConverter
implements ArrayConverter {
    private final ConverterService converterService;

    public StringToArrayConverter(ConverterService converterService) {
        this.converterService = converterService;
    }

    @Override
    public boolean support(Class<?> sourceType, Class<?> targetType) {
        return String.class.equals(sourceType) && targetType.isArray();
    }

    @Override
    public Object convert(Object source, Class<?> sourceType, Class<?> targetType) {
        if (this.support(sourceType, targetType)) {
            if (source == null || source.toString().length() == 0) {
                return null;
            }
            String[] sourceArray = source.toString().split(",");
            Class<?> componentType = targetType.getComponentType();
            Object targetArray = Array.newInstance(componentType, sourceArray.length);
            for (int i = 0; i < sourceArray.length; ++i) {
                Object value = this.converterService.convert(sourceArray[i], componentType);
                Array.set(targetArray, i, value);
            }
            return targetArray;
        }
        throw Exceptions.fail(String.format("unsupported [%s] convert from [%s] to [%s]", source, sourceType, targetType));
    }

    @Override
    public ConverterTypePair pair() {
        return ConverterTypePair.create(String.class, Array.class);
    }
}

