/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.convert;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import vip.justlive.oxygen.core.convert.Converter;
import vip.justlive.oxygen.core.convert.ConverterTypePair;
import vip.justlive.oxygen.core.exception.Exceptions;

public class StringToBooleanConverter
implements Converter<String, Boolean> {
    private static final List<String> TRUE_VALUES = Arrays.asList("true", "on", "yes", "1");
    private static final List<String> FALSE_VALUES = Arrays.asList("false", "off", "no", "0");

    @Override
    public Boolean convert(String source) {
        String value = source;
        if (value == null || value.trim().isEmpty()) {
            return Boolean.FALSE;
        }
        if (TRUE_VALUES.contains(value = value.toLowerCase())) {
            return Boolean.TRUE;
        }
        if (FALSE_VALUES.contains(value)) {
            return Boolean.FALSE;
        }
        throw Exceptions.fail("Invalid boolean value '" + source + "'");
    }

    @Override
    public Set<ConverterTypePair> pairs() {
        HashSet<ConverterTypePair> pairs = new HashSet<ConverterTypePair>(2, 1.0f);
        pairs.add(ConverterTypePair.create(String.class, Boolean.TYPE));
        pairs.add(ConverterTypePair.create(String.class, Boolean.class));
        return pairs;
    }
}

