/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.convert;

import java.util.HashSet;
import java.util.Set;
import vip.justlive.oxygen.core.convert.Converter;
import vip.justlive.oxygen.core.convert.ConverterTypePair;
import vip.justlive.oxygen.core.exception.Exceptions;

public class StringToCharacterConverter
implements Converter<String, Character> {
    @Override
    public Character convert(String source) {
        if (source == null || source.isEmpty()) {
            return null;
        }
        if (source.length() > 1) {
            throw Exceptions.fail(String.format("Can only convert String[%s] to Character", source));
        }
        return Character.valueOf(source.charAt(0));
    }

    @Override
    public Set<ConverterTypePair> pairs() {
        HashSet<ConverterTypePair> pairs = new HashSet<ConverterTypePair>(2, 1.0f);
        pairs.add(ConverterTypePair.create(String.class, Character.class));
        pairs.add(ConverterTypePair.create(String.class, Character.TYPE));
        return pairs;
    }
}

