/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.convert;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import vip.justlive.oxygen.core.convert.Converter;
import vip.justlive.oxygen.core.convert.ConverterFactory;
import vip.justlive.oxygen.core.convert.ConverterTypePair;
import vip.justlive.oxygen.core.util.ClassUtils;
import vip.justlive.oxygen.core.util.NumberUtils;

public class StringToNumberConverterFactory
implements ConverterFactory<String, Number> {
    @Override
    public <T extends Number> Converter<String, T> getConverter(Class<T> targetType) {
        return new StringToNumber<T>(targetType);
    }

    @Override
    public List<Converter<Object, Object>> converters() {
        ArrayList<Converter<Object, Object>> converters = new ArrayList<Converter<Object, Object>>();
        for (Class<? extends Number> clazz : NumberUtils.STANDARD_NUMBER_TYPES) {
            StringToNumber<? extends Number> c = new StringToNumber<Number>(clazz);
            converters.add(c);
        }
        return converters;
    }

    private static final class StringToNumber<T extends Number>
    implements Converter<String, T> {
        private final Class<T> targetType;

        public StringToNumber(Class<T> targetType) {
            this.targetType = targetType;
        }

        @Override
        public T convert(String source) {
            if (source == null || source.isEmpty()) {
                return null;
            }
            return NumberUtils.parseNumber(source, this.targetType);
        }

        @Override
        public Set<ConverterTypePair> pairs() {
            HashSet<ConverterTypePair> pairs = new HashSet<ConverterTypePair>(2, 1.0f);
            pairs.add(ConverterTypePair.create(String.class, this.targetType));
            Class<T> unwrapClass = ClassUtils.unwrap(this.targetType);
            if (unwrapClass != this.targetType) {
                pairs.add(ConverterTypePair.create(String.class, unwrapClass));
            }
            return pairs;
        }
    }
}

