/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.exception;

import vip.justlive.oxygen.core.exception.CodedException;
import vip.justlive.oxygen.core.exception.ErrorCode;
import vip.justlive.oxygen.core.exception.NoStackException;
import vip.justlive.oxygen.core.exception.WrappedException;

public final class Exceptions {
    public static CodedException wrap(Throwable e) {
        if (e instanceof CodedException) {
            return (CodedException)e;
        }
        return new WrappedException(e);
    }

    public static CodedException wrap(Throwable e, String message) {
        return Exceptions.wrap(e, Exceptions.errorMessage(message));
    }

    public static CodedException wrap(Throwable e, String code, String message) {
        return Exceptions.wrap(e, Exceptions.errorMessage(code, message));
    }

    public static CodedException wrap(Throwable e, ErrorCode errorCode) {
        if (e instanceof CodedException) {
            return (CodedException)e;
        }
        return new WrappedException(e, errorCode);
    }

    public static ErrorCode errorMessage(String message) {
        return new ErrorCode(message);
    }

    public static ErrorCode errorMessage(String code, String message) {
        return new ErrorCode(code, message);
    }

    public static ErrorCode errorMessage(String module, String code, String message) {
        return new ErrorCode(module, code, message);
    }

    public static CodedException fail(String message) {
        return Exceptions.fail(Exceptions.errorMessage(message), new Object[0]);
    }

    public static CodedException fail(String code, String message, Object ... args) {
        return Exceptions.fail(Exceptions.errorMessage(code, message), args);
    }

    public static CodedException fail(ErrorCode errCode, Object ... args) {
        return new NoStackException(errCode, args);
    }

    public static CodedException failWithData(String message, Object data) {
        return Exceptions.failWithData(Exceptions.errorMessage(message), data, new Object[0]);
    }

    public static CodedException failWithData(String code, String message, Object data, Object ... args) {
        return Exceptions.failWithData(Exceptions.errorMessage(code, message), data, args);
    }

    public static CodedException failWithData(ErrorCode errCode, Object data, Object ... args) {
        return new NoStackException(errCode, args, data);
    }

    public static CodedException fault(String message) {
        return Exceptions.fault(Exceptions.errorMessage(message), new Object[0]);
    }

    public static CodedException fault(String code, String message, Object ... args) {
        return Exceptions.fault(Exceptions.errorMessage(code, message), args);
    }

    public static CodedException fault(Throwable e, String code, String message, Object ... args) {
        return Exceptions.fault(e, Exceptions.errorMessage(code, message), args);
    }

    public static CodedException fault(ErrorCode errCode, Object ... args) {
        return new CodedException(errCode, args);
    }

    public static CodedException fault(Throwable e, ErrorCode errCode, Object ... args) {
        return new CodedException(e, errCode, args);
    }

    public static CodedException faultWithData(String message, Object data) {
        return Exceptions.faultWithData(Exceptions.errorMessage(message), data, new Object[0]);
    }

    public static CodedException faultWithData(String code, String message, Object data, Object ... args) {
        return Exceptions.faultWithData(Exceptions.errorMessage(code, message), data, args);
    }

    public static CodedException faultWithData(Throwable e, String code, String message, Object data, Object ... args) {
        return Exceptions.faultWithData(e, Exceptions.errorMessage(code, message), data, args);
    }

    public static CodedException faultWithData(ErrorCode errCode, Object data, Object ... args) {
        return new CodedException(errCode, args, data);
    }

    public static CodedException faultWithData(Throwable e, ErrorCode errCode, Object data, Object ... args) {
        return new CodedException(e, errCode, args, data);
    }

    private Exceptions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

