/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import vip.justlive.oxygen.core.io.SourceResource;
import vip.justlive.oxygen.core.util.ClassUtils;
import vip.justlive.oxygen.core.util.MoreObjects;
import vip.justlive.oxygen.core.util.Urls;

public class ClassPathResource
implements SourceResource {
    private final String path;
    private ClassLoader classLoader;
    private Class<?> clazz;

    public ClassPathResource(String path) {
        this(path, (ClassLoader)null);
    }

    public ClassPathResource(String path, ClassLoader classLoader) {
        this.path = Urls.cutRootPath(MoreObjects.notNull(path));
        this.classLoader = classLoader;
    }

    public ClassPathResource(String path, Class<?> clazz) {
        this.path = Urls.cutRootPath(MoreObjects.notNull(path));
        this.clazz = clazz;
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        InputStream is = this.clazz != null ? this.clazz.getResourceAsStream(this.path) : (this.classLoader != null ? this.classLoader.getResourceAsStream(this.path) : ClassUtils.getDefaultClassLoader().getResourceAsStream(this.path));
        if (is == null) {
            throw new FileNotFoundException(this.path + " cannot be opened because it does not exist");
        }
        return is;
    }

    @Override
    public boolean isFile() {
        URL url = this.getURL0();
        if (url != null) {
            return "file".equals(url.getProtocol());
        }
        return false;
    }

    @Override
    public File getFile() throws IOException {
        if (this.isFile()) {
            try {
                return new File(Urls.toURI(this.getURL()).getSchemeSpecificPart());
            }
            catch (URISyntaxException e) {
                return new File(this.getURL0().getFile());
            }
        }
        return null;
    }

    private URL getURL0() {
        if (this.clazz != null) {
            return this.clazz.getResource(this.path);
        }
        if (this.classLoader != null) {
            return this.classLoader.getResource(this.path);
        }
        return ClassLoader.getSystemResource(this.path);
    }

    @Override
    public URL getURL() throws IOException {
        URL url = this.getURL0();
        if (url == null) {
            throw new FileNotFoundException(this.path + " cannot be found");
        }
        return url;
    }

    @Override
    public SourceResource createRelative(String path) {
        ClassPathResource resource = new ClassPathResource(Urls.relativePath(this.path, path));
        resource.classLoader = this.classLoader;
        resource.clazz = this.clazz;
        return resource;
    }
}

