/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import vip.justlive.oxygen.core.io.SourceResource;
import vip.justlive.oxygen.core.util.MoreObjects;
import vip.justlive.oxygen.core.util.Urls;

public class UrlResource
implements SourceResource {
    private final URL url;

    public UrlResource(URL url) {
        this.url = MoreObjects.notNull(url);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        URLConnection con = this.url.openConnection();
        try {
            return con.getInputStream();
        }
        catch (IOException ex) {
            if (con instanceof HttpURLConnection) {
                ((HttpURLConnection)con).disconnect();
            }
            throw ex;
        }
    }

    @Override
    public String path() {
        return this.url.toString();
    }

    @Override
    public boolean isFile() {
        return "file".equals(this.url.getProtocol());
    }

    @Override
    public File getFile() {
        if (this.isFile()) {
            try {
                return new File(Urls.toURI(this.url).getSchemeSpecificPart());
            }
            catch (URISyntaxException e) {
                return new File(this.url.getFile());
            }
        }
        return null;
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    @Override
    public SourceResource createRelative(String path) throws MalformedURLException {
        if (path.startsWith("/")) {
            path = path.substring("/".length());
        }
        return new UrlResource(new URL(this.url, path));
    }
}

