/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.net.aio.core;

import java.util.function.LongUnaryOperator;
import vip.justlive.oxygen.core.net.aio.core.ChannelContext;

public class BeatProcessor
implements Runnable,
LongUnaryOperator {
    private final ChannelContext channelContext;

    @Override
    public void run() {
        if (this.channelContext.isClosed()) {
            return;
        }
        long last = Math.max(this.channelContext.getLastReceivedAt(), this.channelContext.getLastSentAt());
        if (System.currentTimeMillis() - last >= this.channelContext.getGroupContext().getBeatInterval()) {
            Object beat = this.channelContext.getGroupContext().getAioHandler().beat(this.channelContext);
            if (beat == null) {
                return;
            }
            this.channelContext.write(beat);
        }
    }

    @Override
    public long applyAsLong(long deadline) {
        if (this.channelContext.getGroupContext().isStopped() || this.channelContext.getGroupContext().getAioHandler().beat(this.channelContext) == null) {
            return Long.MIN_VALUE;
        }
        long nextTime = Math.max(this.channelContext.getLastReceivedAt(), this.channelContext.getLastSentAt()) + this.channelContext.getGroupContext().getBeatInterval();
        if (nextTime <= deadline) {
            nextTime = deadline + this.channelContext.getGroupContext().getBeatInterval();
        }
        return nextTime;
    }

    public BeatProcessor(ChannelContext channelContext) {
        this.channelContext = channelContext;
    }
}

