/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.net.aio.core;

import java.nio.channels.AsynchronousChannelGroup;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import vip.justlive.oxygen.core.net.aio.core.AioHandler;
import vip.justlive.oxygen.core.net.aio.core.AioListener;
import vip.justlive.oxygen.core.net.aio.core.ChannelContext;
import vip.justlive.oxygen.core.util.CaughtConsumer;
import vip.justlive.oxygen.core.util.ThreadUtils;

public class GroupContext {
    private final AioHandler aioHandler;
    private AioListener aioListener;
    private volatile boolean stopped;
    private int bufferCapacity = 8192;
    private long beatInterval = 5000L;
    private boolean retryEnabled = false;
    private long retryInterval = 5000L;
    private int retryMaxAttempts = 0;
    private int acceptThreads = 100;
    private int acceptMaxWaiter = 10000;
    private int workerThreads = 200;
    private int workerMaxWaiter = 1000000;
    private boolean daemon = false;
    private ThreadPoolExecutor groupExecutor;
    private ThreadPoolExecutor workerExecutor;
    private AsynchronousChannelGroup channelGroup;
    private Map<Long, ChannelContext> channels = new ConcurrentHashMap<Long, ChannelContext>(16, 0.5f);

    public void close() {
        this.stopped = true;
        this.channels.values().forEach(new CaughtConsumer<ChannelContext>(ChannelContext::close));
        this.channels.clear();
        if (this.channelGroup != null) {
            this.channelGroup.shutdown();
        }
        this.groupExecutor.shutdown();
        if (this.workerExecutor != null) {
            this.workerExecutor.shutdown();
        }
    }

    public ThreadPoolExecutor getGroupExecutor() {
        if (this.groupExecutor == null) {
            this.groupExecutor = ThreadUtils.newThreadPool(1, this.acceptThreads, 120, this.acceptMaxWaiter, "aio-server-%d", this.daemon);
            this.groupExecutor.prestartCoreThread();
        }
        return this.groupExecutor;
    }

    public ThreadPoolExecutor getWorkerExecutor() {
        if (this.workerExecutor == null) {
            this.workerExecutor = ThreadUtils.newThreadPool(1, this.workerThreads, 120, this.workerMaxWaiter, "aio-worker-%d");
            this.workerExecutor.prestartCoreThread();
        }
        return this.workerExecutor;
    }

    public void bind(ChannelContext channelContext) {
        if (channelContext != null) {
            this.channels.put(channelContext.getId(), channelContext);
        }
    }

    public void unbind(ChannelContext channelContext) {
        if (channelContext != null) {
            this.channels.remove(channelContext.getId());
        }
    }

    public AioHandler getAioHandler() {
        return this.aioHandler;
    }

    public AioListener getAioListener() {
        return this.aioListener;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public int getBufferCapacity() {
        return this.bufferCapacity;
    }

    public long getBeatInterval() {
        return this.beatInterval;
    }

    public boolean isRetryEnabled() {
        return this.retryEnabled;
    }

    public long getRetryInterval() {
        return this.retryInterval;
    }

    public int getRetryMaxAttempts() {
        return this.retryMaxAttempts;
    }

    public int getAcceptThreads() {
        return this.acceptThreads;
    }

    public int getAcceptMaxWaiter() {
        return this.acceptMaxWaiter;
    }

    public int getWorkerThreads() {
        return this.workerThreads;
    }

    public int getWorkerMaxWaiter() {
        return this.workerMaxWaiter;
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public AsynchronousChannelGroup getChannelGroup() {
        return this.channelGroup;
    }

    public Map<Long, ChannelContext> getChannels() {
        return this.channels;
    }

    public GroupContext setAioListener(AioListener aioListener) {
        this.aioListener = aioListener;
        return this;
    }

    public GroupContext setStopped(boolean stopped) {
        this.stopped = stopped;
        return this;
    }

    public GroupContext setBufferCapacity(int bufferCapacity) {
        this.bufferCapacity = bufferCapacity;
        return this;
    }

    public GroupContext setBeatInterval(long beatInterval) {
        this.beatInterval = beatInterval;
        return this;
    }

    public GroupContext setRetryEnabled(boolean retryEnabled) {
        this.retryEnabled = retryEnabled;
        return this;
    }

    public GroupContext setRetryInterval(long retryInterval) {
        this.retryInterval = retryInterval;
        return this;
    }

    public GroupContext setRetryMaxAttempts(int retryMaxAttempts) {
        this.retryMaxAttempts = retryMaxAttempts;
        return this;
    }

    public GroupContext setAcceptThreads(int acceptThreads) {
        this.acceptThreads = acceptThreads;
        return this;
    }

    public GroupContext setAcceptMaxWaiter(int acceptMaxWaiter) {
        this.acceptMaxWaiter = acceptMaxWaiter;
        return this;
    }

    public GroupContext setWorkerThreads(int workerThreads) {
        this.workerThreads = workerThreads;
        return this;
    }

    public GroupContext setWorkerMaxWaiter(int workerMaxWaiter) {
        this.workerMaxWaiter = workerMaxWaiter;
        return this;
    }

    public GroupContext setDaemon(boolean daemon) {
        this.daemon = daemon;
        return this;
    }

    public GroupContext setGroupExecutor(ThreadPoolExecutor groupExecutor) {
        this.groupExecutor = groupExecutor;
        return this;
    }

    public GroupContext setWorkerExecutor(ThreadPoolExecutor workerExecutor) {
        this.workerExecutor = workerExecutor;
        return this;
    }

    public GroupContext setChannelGroup(AsynchronousChannelGroup channelGroup) {
        this.channelGroup = channelGroup;
        return this;
    }

    public GroupContext setChannels(Map<Long, ChannelContext> channels) {
        this.channels = channels;
        return this;
    }

    public GroupContext(AioHandler aioHandler) {
        this.aioHandler = aioHandler;
    }
}

