/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.net.aio.core;

import java.nio.channels.AsynchronousSocketChannel;
import java.util.concurrent.TimeUnit;
import java.util.function.LongUnaryOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vip.justlive.oxygen.core.net.aio.core.BeatProcessor;
import vip.justlive.oxygen.core.net.aio.core.ChannelContext;
import vip.justlive.oxygen.core.net.aio.core.ConnectHandler;
import vip.justlive.oxygen.core.net.aio.core.Utils;
import vip.justlive.oxygen.core.util.ThreadUtils;

public class RetryProcessor
implements Runnable,
LongUnaryOperator {
    private static final Logger log = LoggerFactory.getLogger(RetryProcessor.class);
    private final ChannelContext channelContext;

    @Override
    public void run() {
        try {
            if (!this.channelContext.isClosed()) {
                return;
            }
            int retryAttempts = this.channelContext.getRetryAttempts() + 1;
            this.channelContext.setRetryAttempts(retryAttempts);
            if (this.channelContext.getGroupContext().getRetryMaxAttempts() > 0 && retryAttempts > this.channelContext.getGroupContext().getRetryMaxAttempts()) {
                log.error("{} client try to connect to {} reached the max attempts [{}]", new Object[]{this.channelContext, this.channelContext.getServerAddress(), this.channelContext.getGroupContext().getRetryMaxAttempts()});
                this.channelContext.close();
                return;
            }
            if (log.isDebugEnabled()) {
                log.info("{} client try to connect to {} for {} attempt(s)", new Object[]{this.channelContext, this.channelContext.getServerAddress(), retryAttempts});
            }
            AsynchronousSocketChannel channel = Utils.create(this.channelContext.getGroupContext());
            this.channelContext.setChannel(channel);
            channel.connect(this.channelContext.getServerAddress(), this.channelContext, ConnectHandler.INSTANCE);
            this.channelContext.join();
            BeatProcessor beat = new BeatProcessor(this.channelContext);
            ThreadUtils.globalTimer().scheduleWithDelay(beat, this.channelContext.getGroupContext().getBeatInterval(), TimeUnit.MILLISECONDS, beat);
        }
        catch (Exception e) {
            log.error("{} client try to connect to {} failed for {} attempt(s)", new Object[]{this.channelContext, this.channelContext.getRetryAttempts(), this.channelContext.getServerAddress(), e});
        }
    }

    @Override
    public long applyAsLong(long operand) {
        boolean stop;
        boolean bl = stop = !this.channelContext.isClosed() || this.channelContext.getGroupContext().getRetryMaxAttempts() > 0 && this.channelContext.getRetryAttempts() > this.channelContext.getGroupContext().getRetryMaxAttempts();
        if (stop) {
            return Long.MIN_VALUE;
        }
        return System.currentTimeMillis() + this.channelContext.getGroupContext().getRetryInterval();
    }

    public RetryProcessor(ChannelContext channelContext) {
        this.channelContext = channelContext;
    }
}

