/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.net.aio.core;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousServerSocketChannel;
import vip.justlive.oxygen.core.net.aio.core.AcceptHandler;
import vip.justlive.oxygen.core.net.aio.core.GroupContext;

public class Server {
    private final GroupContext groupContext;
    private InetSocketAddress serverAddress;
    private AsynchronousServerSocketChannel serverChannel;

    public void start(String host, int port) throws IOException {
        this.start(new InetSocketAddress(host, port));
    }

    public void start(InetSocketAddress address) throws IOException {
        this.groupContext.setStopped(false);
        AsynchronousChannelGroup channelGroup = AsynchronousChannelGroup.withThreadPool(this.groupContext.getGroupExecutor());
        this.groupContext.setChannelGroup(channelGroup);
        this.serverAddress = address;
        this.serverChannel = ((AsynchronousServerSocketChannel)AsynchronousServerSocketChannel.open(channelGroup).setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true)).bind(address);
        this.serverChannel.accept(this, new AcceptHandler());
    }

    public void stop() {
        if (this.groupContext.isStopped()) {
            return;
        }
        this.groupContext.setStopped(true);
        try {
            this.serverChannel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.groupContext.close();
    }

    public GroupContext getGroupContext() {
        return this.groupContext;
    }

    public InetSocketAddress getServerAddress() {
        return this.serverAddress;
    }

    public AsynchronousServerSocketChannel getServerChannel() {
        return this.serverChannel;
    }

    public Server(GroupContext groupContext) {
        this.groupContext = groupContext;
    }
}

