/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.net.aio.core;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vip.justlive.oxygen.core.net.aio.core.GroupContext;
import vip.justlive.oxygen.core.util.SystemUtils;

public final class Utils {
    private static final Logger log = LoggerFactory.getLogger(Utils.class);

    public static void close(AsynchronousSocketChannel channel) {
        if (channel == null) {
            return;
        }
        try {
            channel.shutdownInput();
        }
        catch (IOException e) {
            log.error("close channel.input error", (Throwable)e);
        }
        try {
            channel.shutdownOutput();
        }
        catch (IOException e) {
            log.error("close channel.output error", (Throwable)e);
        }
        try {
            channel.close();
        }
        catch (IOException e) {
            log.error("close channel error", (Throwable)e);
        }
    }

    public static ByteBuffer composite(List<ByteBuffer> buffers) {
        int capacity = 0;
        for (ByteBuffer buffer : buffers) {
            capacity += buffer.remaining();
        }
        ByteBuffer ret = ByteBuffer.allocate(capacity);
        for (ByteBuffer buffer : buffers) {
            ret.put(buffer);
        }
        ret.position(0);
        ret.limit(ret.capacity());
        return ret;
    }

    public static AsynchronousSocketChannel create(GroupContext groupContext) throws IOException {
        return Utils.create(groupContext, new InetSocketAddress(SystemUtils.findAvailablePort()));
    }

    public static AsynchronousSocketChannel create(GroupContext groupContext, InetSocketAddress address) throws IOException {
        return ((AsynchronousSocketChannel)((AsynchronousSocketChannel)((AsynchronousSocketChannel)AsynchronousSocketChannel.open(groupContext.getChannelGroup()).setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)true)).setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true)).setOption((SocketOption)StandardSocketOptions.SO_KEEPALIVE, (Object)true)).bind(address);
    }

    private Utils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

