/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.net.aio.core;

import java.nio.ByteBuffer;
import java.nio.channels.CompletionHandler;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vip.justlive.oxygen.core.net.aio.core.ChannelContext;

public class WriteHandler
implements CompletionHandler<Integer, WriteContext> {
    private static final Logger log = LoggerFactory.getLogger(WriteHandler.class);
    private final ChannelContext channelContext;

    @Override
    public void completed(Integer result, WriteContext ctx) {
        this.channelContext.setLastSentAt(System.currentTimeMillis());
        if (ctx.buffer.hasRemaining()) {
            if (log.isDebugEnabled()) {
                log.debug("{} sent remained. {}/{}", new Object[]{this.channelContext, ctx.buffer.position(), ctx.buffer.limit()});
            }
            this.channelContext.getChannel().write(ctx.buffer, ctx, this);
        } else {
            ctx.future.complete(null);
        }
    }

    @Override
    public void failed(Throwable exc, WriteContext ctx) {
        ctx.future.completeExceptionally(exc);
    }

    public WriteHandler(ChannelContext channelContext) {
        this.channelContext = channelContext;
    }

    static class WriteContext {
        final CompletableFuture<Void> future;
        final ByteBuffer buffer;

        public WriteContext(CompletableFuture<Void> future, ByteBuffer buffer) {
            this.future = future;
            this.buffer = buffer;
        }
    }
}

