/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.net.aio.core;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Semaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vip.justlive.oxygen.core.config.ConfigFactory;
import vip.justlive.oxygen.core.net.aio.core.AioHandler;
import vip.justlive.oxygen.core.net.aio.core.AioListener;
import vip.justlive.oxygen.core.net.aio.core.ChannelContext;
import vip.justlive.oxygen.core.net.aio.core.Utils;
import vip.justlive.oxygen.core.net.aio.core.WriteHandler;
import vip.justlive.oxygen.core.util.AbstractQueueWorker;
import vip.justlive.oxygen.core.util.MoreObjects;

public class WriteWorker
extends AbstractQueueWorker<Object> {
    private static final Logger log = LoggerFactory.getLogger(WriteWorker.class);
    private final AioHandler aioHandler;
    private final Semaphore semaphore;
    private final ChannelContext channelContext;
    private CompletableFuture<Void> writeFuture;
    private final boolean useFuture;

    WriteWorker(ChannelContext channelContext) {
        super(channelContext.getGroupContext().getWorkerExecutor());
        this.channelContext = channelContext;
        this.aioHandler = channelContext.getGroupContext().getAioHandler();
        this.useFuture = Boolean.parseBoolean(ConfigFactory.getProperty("aio.write.future", "false"));
        if (this.useFuture) {
            this.writeFuture = CompletableFuture.completedFuture(null);
            this.semaphore = null;
        } else {
            this.semaphore = new Semaphore(1, true);
        }
    }

    @Override
    public void stop() {
        if (this.useFuture) {
            this.writeFuture.cancel(true);
        }
        super.stop();
    }

    @Override
    public void handle(List<Object> data) {
        if (this.stopped) {
            return;
        }
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>(data.size());
        for (Object obj : data) {
            ByteBuffer buffer = this.aioHandler.encode(obj, this.channelContext);
            if (!buffer.hasRemaining()) {
                buffer.flip();
            }
            buffers.add(buffer);
        }
        if (this.channelContext.isClosed()) {
            return;
        }
        ByteBuffer buffer = Utils.composite(buffers);
        if (this.useFuture) {
            this.write(buffer, data);
        } else {
            this.write0(buffer, data);
        }
    }

    private void write0(ByteBuffer buffer, List<Object> data) {
        this.semaphore.acquireUninterruptibly();
        if (this.channelContext.isClosed()) {
            this.semaphore.release();
            return;
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        future.whenComplete((r, e) -> this.complete((Throwable)e, data));
        this.write(future, buffer);
    }

    private synchronized void write(ByteBuffer buffer, List<Object> data) {
        CompletableFuture future = new CompletableFuture();
        future.whenComplete((r, e) -> this.complete((Throwable)e, data));
        this.writeFuture.whenComplete((r, e) -> this.write(future, buffer));
        this.writeFuture = future;
    }

    private void write(CompletableFuture<Void> future, ByteBuffer buffer) {
        try {
            WriteHandler.WriteContext ctx = new WriteHandler.WriteContext(future, buffer);
            this.channelContext.getChannel().write(ctx.buffer, ctx, this.channelContext.getWriteHandler());
        }
        catch (Exception e) {
            log.error("write error", (Throwable)e);
            future.completeExceptionally(e);
        }
    }

    private void complete(Throwable exc, List<Object> data) {
        AioListener listener;
        if (!this.useFuture) {
            this.semaphore.release();
        }
        if ((listener = this.channelContext.getGroupContext().getAioListener()) != null) {
            MoreObjects.caughtForeach(data, item -> listener.onWriteHandled(this.channelContext, item, exc));
        }
    }
}

