/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.net.http;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import vip.justlive.oxygen.core.util.IoUtils;

public class HttpResponse
implements Closeable {
    private final HttpURLConnection connection;
    private final int code;
    private final String message;
    private final InputStream body;
    private final Charset charset;
    private Map<String, String> headers;

    HttpResponse(HttpURLConnection connection, Charset charset) throws IOException {
        this.connection = connection;
        this.code = connection.getResponseCode();
        this.message = connection.getResponseMessage();
        InputStream in = connection.getErrorStream();
        this.body = in == null ? connection.getInputStream() : in;
        this.charset = charset;
    }

    public Map<String, String> getHeaders() {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>(4);
            int i = 0;
            while (true) {
                String name;
                if ((name = this.connection.getHeaderFieldKey(i)) != null && name.trim().length() > 0) {
                    this.headers.put(name, this.connection.getHeaderField(i));
                } else if (i > 0) break;
                ++i;
            }
        }
        return this.headers;
    }

    public String bodyAsString() throws IOException {
        return this.bodyAsString(this.charset);
    }

    public String bodyAsString(Charset charset) throws IOException {
        return IoUtils.toString(this.body, charset);
    }

    @Override
    public void close() throws IOException {
        if (this.body != null) {
            IoUtils.drain(this.body);
            this.body.close();
        }
        this.connection.disconnect();
    }

    public HttpURLConnection getConnection() {
        return this.connection;
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public InputStream getBody() {
        return this.body;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpResponse)) {
            return false;
        }
        HttpResponse other = (HttpResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        HttpURLConnection this$connection = this.getConnection();
        HttpURLConnection other$connection = other.getConnection();
        if (this$connection == null ? other$connection != null : !this$connection.equals(other$connection)) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        InputStream this$body = this.getBody();
        InputStream other$body = other.getBody();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        Charset this$charset = this.getCharset();
        Charset other$charset = other.getCharset();
        if (this$charset == null ? other$charset != null : !((Object)this$charset).equals(other$charset)) {
            return false;
        }
        Map<String, String> this$headers = this.getHeaders();
        Map<String, String> other$headers = other.getHeaders();
        return !(this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HttpResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HttpURLConnection $connection = this.getConnection();
        result = result * 59 + ($connection == null ? 43 : $connection.hashCode());
        result = result * 59 + this.getCode();
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        InputStream $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        Charset $charset = this.getCharset();
        result = result * 59 + ($charset == null ? 43 : ((Object)$charset).hashCode());
        Map<String, String> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        return result;
    }

    public String toString() {
        return "HttpResponse(connection=" + this.getConnection() + ", code=" + this.getCode() + ", message=" + this.getMessage() + ", body=" + this.getBody() + ", charset=" + this.getCharset() + ", headers=" + this.getHeaders() + ")";
    }
}

