/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.util;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import vip.justlive.oxygen.core.exception.Exceptions;

public class Bytes {
    public static final byte AND = 38;
    public static final byte ANY = 42;
    public static final byte CLOSE_BRACE = 125;
    public static final byte CLOSE_BRACKET = 93;
    public static final byte CLOSE_PAREN = 41;
    public static final byte COLON = 58;
    public static final byte COMMA = 44;
    public static final byte CR = 13;
    public static final byte DASH = 45;
    public static final byte DOLLAR = 36;
    public static final byte DOT = 46;
    public static final byte DOUBLE_QUOTATION_MARK = 34;
    public static final byte EQUAL = 61;
    public static final byte LF = 10;
    public static final byte OCTOTHORP = 35;
    public static final byte OPEN_BRACE = 123;
    public static final byte OPEN_BRACKET = 91;
    public static final byte OPEN_PAREN = 40;
    public static final byte QUESTION_MARK = 63;
    public static final byte SEMICOLON = 59;
    public static final byte SLASH = 47;
    public static final byte SPACE = 32;
    public static final byte UNDERSCORE = 95;
    protected byte[] buffer;
    protected int count;
    private int padding;

    public Bytes() {
        this(32);
    }

    public Bytes(int size) {
        this(size, 32);
    }

    public Bytes(int size, int padding) {
        if (size < 0) {
            throw Exceptions.fail("[size] should be positive");
        }
        this.buffer = new byte[size];
        this.padding = padding;
    }

    public synchronized Bytes write(byte b) {
        this.ensureCapacity(this.count + 1);
        this.buffer[this.count] = b;
        ++this.count;
        return this;
    }

    public Bytes write(String str) {
        return this.write(str, StandardCharsets.UTF_8);
    }

    public Bytes write(String str, Charset charset) {
        if (str == null) {
            return this;
        }
        return this.write(str.getBytes(charset));
    }

    public Bytes write(byte[] b) {
        return this.write(b, 0, b.length);
    }

    public synchronized Bytes write(byte[] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0 || off + len - b.length > 0) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureCapacity(this.count + len);
        System.arraycopy(b, off, this.buffer, this.count, len);
        this.count += len;
        return this;
    }

    public synchronized void reset() {
        this.count = 0;
    }

    public synchronized int size() {
        return this.count;
    }

    public synchronized String toString() {
        return this.toString(StandardCharsets.UTF_8);
    }

    public synchronized String toString(Charset charset) {
        return new String(this.buffer, 0, this.count, charset);
    }

    public synchronized byte[] toArray() {
        return Arrays.copyOf(this.buffer, this.count);
    }

    private void ensureCapacity(int minLength) {
        if (minLength < 0) {
            throw new OutOfMemoryError();
        }
        if (this.buffer.length < minLength) {
            int newSize = minLength + this.padding;
            if (newSize < 0) {
                newSize = Integer.MAX_VALUE;
            }
            this.buffer = Arrays.copyOf(this.buffer, newSize);
        }
    }
}

