/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import vip.justlive.oxygen.core.template.SimpleTemplateEngine;
import vip.justlive.oxygen.core.util.MoreObjects;

public final class Calculator {
    private static final String TEMPLATE = "#{var $result = %s; $out.write('' + $result); }";
    private static final SimpleTemplateEngine ENGINE = new SimpleTemplateEngine();

    public static BigDecimal calculate(String formula) {
        return Calculator.calculate(formula, null);
    }

    public static BigDecimal calculate(String formula, Object data) {
        HashMap<String, Object> attrs = new HashMap<String, Object>(4);
        if (data != null) {
            attrs.putAll(MoreObjects.beanToMap(data));
        }
        return new BigDecimal(ENGINE.render(String.format(TEMPLATE, formula), attrs));
    }

    public static BigDecimal calculate(String formula, Object data, int scale) {
        return Calculator.calculate(formula, data).setScale(scale, RoundingMode.HALF_DOWN);
    }

    private Calculator() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

