/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.util;

import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vip.justlive.oxygen.core.exception.Exceptions;

public class CaughtBiConsumer<T, U>
implements BiConsumer<T, U> {
    private static final Logger log = LoggerFactory.getLogger(CaughtBiConsumer.class);
    private final BiConsumer<T, U> consumer;
    private final boolean thrown;

    public CaughtBiConsumer(BiConsumer<T, U> consumer) {
        this(consumer, false);
    }

    @Override
    public void accept(T t, U u) {
        try {
            this.consumer.accept(t, u);
        }
        catch (Exception e) {
            if (this.thrown) {
                throw Exceptions.wrap(e);
            }
            log.error("consumer error", (Throwable)e);
        }
    }

    @Override
    public CaughtBiConsumer<T, U> andThen(BiConsumer<? super T, ? super U> after) {
        return new CaughtBiConsumer<T, U>(BiConsumer.super.andThen(after), this.thrown);
    }

    public BiConsumer<T, U> getConsumer() {
        return this.consumer;
    }

    public boolean isThrown() {
        return this.thrown;
    }

    public CaughtBiConsumer(BiConsumer<T, U> consumer, boolean thrown) {
        this.consumer = consumer;
        this.thrown = thrown;
    }
}

