/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vip.justlive.oxygen.core.exception.Exceptions;
import vip.justlive.oxygen.core.util.MoreObjects;

public final class ClassUtils {
    private static final Logger log = LoggerFactory.getLogger(ClassUtils.class);
    public static final String ARRAY_SUFFIX = "[]";
    public static final String INTERNAL_ARRAY_PREFIX = "[";
    public static final String NON_PRIMITIVE_ARRAY_PREFIX = "[L";
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TO_WRAPPER_TYPE;
    private static final Map<Class<?>, Class<?>> WRAPPER_TO_PRIMITIVE_TYPE;

    private static void add(Map<Class<?>, Class<?>> forward, Map<Class<?>, Class<?>> backward, Class<?> key, Class<?> value) {
        forward.put(key, value);
        backward.put(value, key);
    }

    public static Set<Class<?>> allPrimitiveTypes() {
        return PRIMITIVE_TO_WRAPPER_TYPE.keySet();
    }

    public static Set<Class<?>> allWrapperTypes() {
        return WRAPPER_TO_PRIMITIVE_TYPE.keySet();
    }

    public static <T> Class<T> wrap(Class<T> type) {
        MoreObjects.notNull(type);
        Class<?> wrapped = PRIMITIVE_TO_WRAPPER_TYPE.get(type);
        return wrapped == null ? type : wrapped;
    }

    public static <T> Class<T> unwrap(Class<T> type) {
        MoreObjects.notNull(type);
        Class<?> unwrapped = WRAPPER_TO_PRIMITIVE_TYPE.get(type);
        return unwrapped == null ? type : unwrapped;
    }

    public static boolean isPrimitive(Class<?> type) {
        return PRIMITIVE_TO_WRAPPER_TYPE.containsKey(type) || WRAPPER_TO_PRIMITIVE_TYPE.containsKey(type);
    }

    public static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (cl == null && (cl = ClassUtils.class.getClassLoader()) == null) {
            try {
                cl = ClassLoader.getSystemClassLoader();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return cl;
    }

    public static Class<?> forName(String name) {
        return ClassUtils.forName(name, ClassUtils.getDefaultClassLoader());
    }

    public static Class<?> forName(String name, ClassLoader classLoader) {
        if (name.endsWith(ARRAY_SUFFIX)) {
            String elementClassName = name.substring(0, name.length() - ARRAY_SUFFIX.length());
            Class<?> elementClass = ClassUtils.forName(elementClassName, classLoader);
            return Array.newInstance(elementClass, 0).getClass();
        }
        if (name.startsWith(NON_PRIMITIVE_ARRAY_PREFIX) && name.endsWith(";")) {
            String elementName = name.substring(NON_PRIMITIVE_ARRAY_PREFIX.length(), name.length() - 1);
            Class<?> elementClass = ClassUtils.forName(elementName, classLoader);
            return Array.newInstance(elementClass, 0).getClass();
        }
        if (name.startsWith(INTERNAL_ARRAY_PREFIX)) {
            String elementName = name.substring(INTERNAL_ARRAY_PREFIX.length());
            Class<?> elementClass = ClassUtils.forName(elementName, classLoader);
            return Array.newInstance(elementClass, 0).getClass();
        }
        ClassLoader clToUse = classLoader;
        if (clToUse == null) {
            clToUse = ClassUtils.getDefaultClassLoader();
        }
        try {
            return clToUse != null ? clToUse.loadClass(name) : Class.forName(name);
        }
        catch (ClassNotFoundException ex) {
            int lastDotIndex = name.lastIndexOf(".");
            if (lastDotIndex != -1) {
                String innerClassName = name.substring(0, lastDotIndex) + "$" + name.substring(lastDotIndex + 1);
                try {
                    return clToUse != null ? clToUse.loadClass(innerClassName) : Class.forName(innerClassName);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            throw Exceptions.wrap(ex);
        }
    }

    public static boolean isPresent(String className) {
        return ClassUtils.isPresent(className, ClassUtils.getDefaultClassLoader());
    }

    public static boolean isPresent(String className, ClassLoader classLoader) {
        try {
            ClassUtils.forName(className, classLoader);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean isCglibProxy(Object object) {
        return ClassUtils.isCglibProxyClass(object.getClass());
    }

    public static boolean isCglibProxyClass(Class<?> clazz) {
        return clazz != null && ClassUtils.isCglibProxyClassName(clazz.getName());
    }

    public static boolean isCglibProxyClassName(String className) {
        return className != null && className.contains("$$");
    }

    public static Class<?> getCglibActualClass(Class<?> clazz) {
        Class<?> actualClass = clazz;
        while (ClassUtils.isCglibProxyClass(actualClass)) {
            actualClass = actualClass.getSuperclass();
        }
        return actualClass;
    }

    public static Set<Method> getMethodsAnnotatedWith(Class<?> clazz, Class<? extends Annotation> annotation) {
        HashSet<Method> methods = new HashSet<Method>();
        Class<?> actualClass = ClassUtils.getCglibActualClass(clazz);
        if (actualClass == null) {
            return methods;
        }
        for (Method method : ClassUtils.getAllMethods(actualClass)) {
            if (!method.isAnnotationPresent(annotation)) continue;
            methods.add(method);
        }
        return methods;
    }

    public static Object methodInvoke(Method method, Object bean, Object ... args) {
        try {
            method.setAccessible(true);
            return method.invoke(bean, args);
        }
        catch (IllegalAccessException e) {
            throw Exceptions.wrap(e);
        }
        catch (InvocationTargetException e) {
            throw Exceptions.wrap(e.getTargetException());
        }
    }

    public static Set<Method> getAllMethods(Class<?> clazz) {
        HashSet<Method> methods = new HashSet<Method>();
        Class<?> actualClass = clazz;
        do {
            methods.addAll(Arrays.asList(actualClass.getDeclaredMethods()));
        } while ((actualClass = actualClass.getSuperclass()) != null);
        return methods;
    }

    public static Class<?>[] getConstructorArgsTypes(Class<?> clazz, Object ... args) {
        for (Constructor<?> constructor : clazz.getConstructors()) {
            if (constructor.getParameterCount() != args.length) continue;
            Class<?>[] paramsTypes = constructor.getParameterTypes();
            boolean matched = true;
            for (int i = 0; i < args.length; ++i) {
                if (paramsTypes[i].isAssignableFrom(args[i].getClass())) continue;
                matched = false;
                break;
            }
            if (!matched) continue;
            return paramsTypes;
        }
        return new Class[args.length];
    }

    public static Constructor<?> getConstructorAnnotatedWith(Class<?> clazz, Class<? extends Annotation> annotation) {
        return ClassUtils.getConstructorAnnotatedWith(clazz.getConstructors(), annotation);
    }

    public static Constructor<?> getConstructorAnnotatedWith(Constructor<?>[] constructors, Class<? extends Annotation> annotation) {
        for (Constructor<?> constructor : constructors) {
            if (!constructor.isAnnotationPresent(annotation)) continue;
            return constructor;
        }
        return null;
    }

    public static boolean isInJavaLangAnnotationPackage(Class<? extends Annotation> annotation) {
        return annotation != null && annotation.getName().startsWith("java.lang.annotation");
    }

    public static boolean isAnnotationPresent(Class<?> clazz, Class<? extends Annotation> annotation) {
        return ClassUtils.getAnnotation(clazz, annotation) != null;
    }

    public static <A extends Annotation> A getAnnotation(Class<?> clazz, Class<A> annotation) {
        A anno = clazz.getAnnotation(annotation);
        if (anno != null) {
            return anno;
        }
        Annotation[] annotations = clazz.getAnnotations();
        LinkedHashSet<Annotation> visited = new LinkedHashSet<Annotation>();
        for (Annotation ann : annotations) {
            ClassUtils.recursivelyCollectAnnotations(visited, ann);
        }
        if (visited.isEmpty()) {
            return null;
        }
        for (Annotation ann : visited) {
            if (ann.annotationType() != annotation) continue;
            return (A)ann;
        }
        return null;
    }

    public static Field[] getAllDeclaredFields(Class<?> clazz) {
        Field[] fields = clazz.getDeclaredFields();
        Class<?> superClass = clazz.getSuperclass();
        if (superClass == null) {
            return fields;
        }
        Field[] superFields = ClassUtils.getAllDeclaredFields(superClass);
        Field[] destFields = new Field[fields.length + superFields.length];
        System.arraycopy(fields, 0, destFields, 0, fields.length);
        System.arraycopy(superFields, 0, destFields, fields.length, superFields.length);
        return destFields;
    }

    public static Field getDeclaredField(Class<?> clazz, String propertyName) {
        Field[] fields;
        for (Field field : fields = ClassUtils.getAllDeclaredFields(clazz)) {
            if (!field.getName().equals(propertyName)) continue;
            return field;
        }
        return null;
    }

    public static Object getValue(Object object, String propertyName) {
        Class<?> clazz = object.getClass();
        return ClassUtils.getValue(object, ClassUtils.getDeclaredField(clazz, propertyName));
    }

    public static Object getValue(Object object, Field field) {
        if (field == null) {
            return null;
        }
        try {
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            return field.get(object);
        }
        catch (IllegalAccessException e) {
            throw Exceptions.wrap(e);
        }
    }

    public static void setValue(Object object, Field field, Object value) {
        try {
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            field.set(object, value);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            log.error("set value {} to class {} error", new Object[]{value, object.getClass(), e});
        }
    }

    public static <T> T newInstance(Class<T> clazz) {
        if (clazz == Integer.class) {
            return (T)Integer.valueOf(0);
        }
        if (clazz == String.class) {
            return (T)"";
        }
        if (clazz == Long.class) {
            return (T)Long.valueOf(0L);
        }
        if (clazz == Short.class) {
            return (T)Short.valueOf((short)0);
        }
        if (clazz == Byte.class) {
            return (T)Byte.valueOf((byte)0);
        }
        if (clazz == Float.class) {
            return (T)Float.valueOf(0.0f);
        }
        if (clazz == Double.class) {
            return (T)Double.valueOf(0.0);
        }
        if (clazz == Boolean.class) {
            return (T)Boolean.FALSE;
        }
        if (clazz == BigDecimal.class) {
            return (T)BigDecimal.ZERO;
        }
        if (clazz == Date.class) {
            return (T)new Date(System.currentTimeMillis());
        }
        if (clazz == Timestamp.class) {
            return (T)new Timestamp(System.currentTimeMillis());
        }
        if (clazz == Map.class) {
            return (T)new HashMap(16);
        }
        try {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw Exceptions.wrap((Throwable)e, String.format("can not instance new object for class [%s]", clazz));
        }
    }

    public static boolean isJavaInternalType(Class<?> type) {
        if (type != null) {
            return type.getClassLoader() == null;
        }
        return false;
    }

    private static void recursivelyCollectAnnotations(Set<Annotation> visited, Annotation annotation) {
        Class<? extends Annotation> annotationType = annotation.annotationType();
        if (annotationType == null || ClassUtils.isInJavaLangAnnotationPackage(annotationType) || !Modifier.isPublic(annotationType.getModifiers()) || !visited.add(annotation)) {
            return;
        }
        for (Annotation metaAnnotation : annotationType.getAnnotations()) {
            ClassUtils.recursivelyCollectAnnotations(visited, metaAnnotation);
        }
    }

    private ClassUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        HashMap primToWrap = new HashMap(16);
        HashMap wrapToPrim = new HashMap(16);
        ClassUtils.add(primToWrap, wrapToPrim, Boolean.TYPE, Boolean.class);
        ClassUtils.add(primToWrap, wrapToPrim, Byte.TYPE, Byte.class);
        ClassUtils.add(primToWrap, wrapToPrim, Character.TYPE, Character.class);
        ClassUtils.add(primToWrap, wrapToPrim, Double.TYPE, Double.class);
        ClassUtils.add(primToWrap, wrapToPrim, Float.TYPE, Float.class);
        ClassUtils.add(primToWrap, wrapToPrim, Integer.TYPE, Integer.class);
        ClassUtils.add(primToWrap, wrapToPrim, Long.TYPE, Long.class);
        ClassUtils.add(primToWrap, wrapToPrim, Short.TYPE, Short.class);
        ClassUtils.add(primToWrap, wrapToPrim, Void.TYPE, Void.class);
        PRIMITIVE_TO_WRAPPER_TYPE = Collections.unmodifiableMap(primToWrap);
        WRAPPER_TO_PRIMITIVE_TYPE = Collections.unmodifiableMap(wrapToPrim);
    }
}

