/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.util;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;

public class Closer
implements Closeable {
    private final Deque<Closeable> stack = new ArrayDeque<Closeable>(4);
    private Throwable thrown;

    public <T extends Closeable> T register(T closeable) {
        if (closeable != null) {
            this.stack.addFirst(closeable);
        }
        return closeable;
    }

    public void thrown(Throwable throwable) {
        this.thrown = throwable;
    }

    @Override
    public void close() throws IOException {
        this.closeQuietly();
        if (this.thrown instanceof IOException) {
            throw (IOException)this.thrown;
        }
        if (this.thrown != null) {
            throw new IOException(this.thrown);
        }
    }

    public void closeQuietly() {
        while (!this.stack.isEmpty()) {
            try {
                this.stack.pop().close();
            }
            catch (Throwable e) {
                if (this.thrown == null) {
                    this.thrown = e;
                    continue;
                }
                this.thrown.addSuppressed(e);
            }
        }
    }

    public Throwable getThrown() {
        return this.thrown;
    }
}

