/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.util;

import java.io.IOException;
import vip.justlive.oxygen.core.exception.Exceptions;

public class CsvWriter {
    public static final char NO_QUOTE_OR_ESCAPE = '\u0000';
    public static final char DEFAULT_SEPARATOR = ',';
    public static final char DEFAULT_ESCAPE = '\"';
    public static final char DEFAULT_QUOTE = '\"';
    public static final String DEFAULT_END = "\r\n";
    private final char separator;
    private final char quote;
    private final char escape;
    protected final String end;

    public CsvWriter() {
        this(',', '\"', '\"');
    }

    public CsvWriter(char separator, char quote, char escape) {
        this(separator, quote, escape, DEFAULT_END);
    }

    public void writeAll(Appendable appendable, Iterable<String[]> lines) {
        this.writeAll(appendable, lines, true);
    }

    public void writeAll(Appendable appendable, Iterable<String[]> lines, boolean applyQuotes) {
        for (String[] line : lines) {
            this.write(appendable, line, applyQuotes);
        }
    }

    public void write(Appendable appendable, Iterable<String> line) {
        this.write(appendable, line, true);
    }

    public void write(Appendable appendable, Iterable<String> line, boolean applyQuotes) {
        if (line == null) {
            return;
        }
        int i = 0;
        for (String element : line) {
            this.writeElement(i++, element, appendable, applyQuotes);
        }
        this.append(appendable, this.end);
    }

    public void write(Appendable appendable, String[] line) {
        this.write(appendable, line, true);
    }

    public void write(Appendable appendable, String[] line, boolean applyQuotes) {
        if (line == null) {
            return;
        }
        for (int i = 0; i < line.length; ++i) {
            this.writeElement(i, line[i], appendable, applyQuotes);
        }
        this.append(appendable, this.end);
    }

    private void writeElement(int index, String element, Appendable appendable, boolean applyQuotes) {
        if (index != 0) {
            this.append(appendable, this.separator);
        }
        if (element == null) {
            return;
        }
        boolean hasSpecialChar = this.hasSpecialChar(element);
        this.appendQuote(applyQuotes, hasSpecialChar, appendable);
        if (hasSpecialChar) {
            this.processLine(element, appendable);
        } else {
            this.append(appendable, element);
        }
        this.appendQuote(applyQuotes, hasSpecialChar, appendable);
    }

    private void processLine(String element, Appendable appendable) {
        for (int i = 0; i < element.length(); ++i) {
            char next = element.charAt(i);
            if (this.escape != '\u0000' && this.checkCharactersToEscape(next)) {
                this.append(appendable, this.escape);
            }
            this.append(appendable, next);
        }
    }

    private boolean checkCharactersToEscape(char next) {
        if (this.quote == '\u0000') {
            return next == this.quote || next == this.escape || next == this.separator || next == '\n';
        }
        return next == this.quote || next == this.escape;
    }

    private boolean hasSpecialChar(String line) {
        return line.indexOf(this.quote) != -1 || line.indexOf(this.escape) != -1 || line.indexOf(this.separator) != -1 || line.contains("\r") || line.contains("\n");
    }

    private void appendQuote(boolean applyQuotes, boolean hasSpecialChar, Appendable appendable) {
        boolean needQuote;
        boolean bl = needQuote = (applyQuotes || hasSpecialChar) && this.quote != '\u0000';
        if (needQuote) {
            this.append(appendable, this.quote);
        }
    }

    private void append(Appendable appendable, CharSequence sequence) {
        try {
            appendable.append(sequence);
        }
        catch (IOException e) {
            throw Exceptions.wrap(e);
        }
    }

    private void append(Appendable appendable, char sequence) {
        try {
            appendable.append(sequence);
        }
        catch (IOException e) {
            throw Exceptions.wrap(e);
        }
    }

    public char getSeparator() {
        return this.separator;
    }

    public char getQuote() {
        return this.quote;
    }

    public char getEscape() {
        return this.escape;
    }

    public String getEnd() {
        return this.end;
    }

    public CsvWriter(char separator, char quote, char escape, String end) {
        this.separator = separator;
        this.quote = quote;
        this.escape = escape;
        this.end = end;
    }
}

