/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vip.justlive.oxygen.core.util.MoreObjects;
import vip.justlive.oxygen.core.util.ThreadUtils;

public class ExpiringMap<K, V>
implements ConcurrentMap<K, V>,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(ExpiringMap.class);
    private static final long serialVersionUID = 1L;
    private static final AtomicInteger INS = new AtomicInteger(0);
    private final transient ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final transient Lock readLock = this.readWriteLock.readLock();
    private final transient Lock writeLock = this.readWriteLock.writeLock();
    private final transient AtomicLong accumulate = new AtomicLong();
    private final transient List<ExpiredListener<K, V>> asyncExpiredListeners;
    private final String name;
    private final int maxSize;
    private final long duration;
    private final TimeUnit timeUnit;
    private final ExpiringPolicy expiringPolicy;
    private final CleanPolicy cleanPolicy;
    private final int scheduleDelay;
    private final int accumulateThreshold;
    private final LruMap<K, V> data;

    private ExpiringMap(Builder<K, V> builder) {
        this.asyncExpiredListeners = ((Builder)builder).asyncExpiredListeners;
        this.maxSize = ((Builder)builder).maxSize;
        this.duration = ((Builder)builder).duration;
        this.timeUnit = ((Builder)builder).timeUnit;
        this.cleanPolicy = ((Builder)builder).cleanPolicy;
        this.expiringPolicy = ((Builder)builder).expiringPolicy;
        this.scheduleDelay = ((Builder)builder).scheduleDelay <= 0 ? Math.max((int)this.timeUnit.toSeconds(this.duration) / 4, 60) : ((Builder)builder).scheduleDelay;
        this.accumulateThreshold = ((Builder)builder).accumulateThreshold;
        int index = INS.getAndIncrement();
        this.name = MoreObjects.firstNonNull(((Builder)builder).name, String.format("Unnamed-%d", index));
        ThreadUtils.globalTimer().scheduleWithFixedDelay(this::runScheduleCleanPolicy, this.scheduleDelay, this.scheduleDelay, TimeUnit.SECONDS);
        this.data = new LruMap().maxSize(this.maxSize).listeners(this.asyncExpiredListeners);
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    public static <K, V> ExpiringMap<K, V> create() {
        return ExpiringMap.builder().build();
    }

    public int realSize() {
        this.readLock.lock();
        try {
            int n = this.data.size();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public int size() {
        this.readLock.lock();
        try {
            int n = (int)this.data.values().parallelStream().filter(r -> !r.isExpired()).count();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        this.readLock.lock();
        try {
            ExpiringValue value = (ExpiringValue)this.data.get(key);
            boolean bl = value != null && !value.isExpired();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object value) {
        this.readLock.lock();
        try {
            for (Map.Entry entry : this.data.entrySet()) {
                ExpiringValue wrapValue = (ExpiringValue)entry.getValue();
                if (wrapValue.isExpired() || !Objects.equals(wrapValue.value, value)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key) {
        this.readLock.lock();
        try {
            ExpiringValue value = (ExpiringValue)this.data.get(key);
            if (value == null || value.isExpired()) {
                V v = null;
                return v;
            }
            this.accessRecord(value);
            Object object = value.value;
            return (V)object;
        }
        finally {
            this.readLock.unlock();
            this.record();
        }
    }

    @Override
    public V put(K key, V value) {
        return this.put(key, value, this.duration);
    }

    public V put(K key, V value, long duration) {
        return this.put(key, value, duration, this.timeUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V put(K key, V value, long duration, TimeUnit timeUnit) {
        this.writeLock.lock();
        try {
            ExpiringValue<V> wrapValue = new ExpiringValue<V>(value, duration, timeUnit);
            ExpiringValue<V> preValue = this.data.put(key, wrapValue);
            if (preValue != null) {
                if (!Objects.equals(((ExpiringValue)preValue).value, value)) {
                    this.notifyListener(key, ((ExpiringValue)preValue).value, RemovalCause.REPLACED);
                }
                if (!preValue.isExpired()) {
                    Object object = ((ExpiringValue)preValue).value;
                    return (V)object;
                }
            }
            V v = null;
            return v;
        }
        finally {
            this.writeLock.unlock();
            this.record();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        this.writeLock.lock();
        try {
            ExpiringValue value = (ExpiringValue)this.data.remove(key);
            if (value == null || value.isExpired()) {
                V v = null;
                return v;
            }
            this.notifyListener(key, value.value, RemovalCause.EXPLICIT);
            Object object = value.value;
            return (V)object;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.writeLock.lock();
        try {
            for (Map.Entry<K, V> entry : m.entrySet()) {
                ExpiringValue<V> preValue = this.data.put(entry.getKey(), new ExpiringValue<V>(entry.getValue(), this.duration, this.timeUnit));
                if (preValue == null || Objects.equals(((ExpiringValue)preValue).value, entry.getValue())) continue;
                this.notifyListener(entry.getKey(), ((ExpiringValue)preValue).value, RemovalCause.REPLACED);
            }
        }
        finally {
            this.writeLock.unlock();
            this.record();
        }
    }

    @Override
    public void clear() {
        this.writeLock.lock();
        try {
            Iterator it = this.data.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry item = it.next();
                it.remove();
                this.notifyListener(item.getKey(), ((ExpiringValue)item.getValue()).value, RemovalCause.EXPLICIT);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public Set<K> keySet() {
        this.readLock.lock();
        try {
            Set set = this.data.entrySet().parallelStream().filter(r -> !((ExpiringValue)r.getValue()).isExpired()).map(Map.Entry::getKey).collect(Collectors.toSet());
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Collection<V> values() {
        this.readLock.lock();
        try {
            Collection collection = this.data.values().parallelStream().filter(r -> !r.isExpired()).map(r -> ((ExpiringValue)r).value).collect(Collectors.toList());
            return collection;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.readLock.lock();
        try {
            Set<Map.Entry<K, V>> set = this.data.entrySet().parallelStream().filter(r -> !((ExpiringValue)r.getValue()).isExpired()).map(r -> new MapEntry(r.getKey(), ((ExpiringValue)r.getValue()).value)).collect(Collectors.toSet());
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public V putIfAbsent(K key, V value) {
        if (this.duration > 0L) {
            return this.putIfAbsent(key, value, this.duration);
        }
        return this.putIfAbsent(key, new ExpiringValue<V>(value));
    }

    public V putIfAbsent(K key, V value, long duration) {
        return this.putIfAbsent(key, value, duration, this.timeUnit);
    }

    public V putIfAbsent(K key, V value, long duration, TimeUnit timeUnit) {
        return this.putIfAbsent(key, new ExpiringValue<V>(value, duration, timeUnit));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key, Object value) {
        this.writeLock.lock();
        try {
            Object k = key;
            ExpiringValue wrapValue = (ExpiringValue)this.data.get(k);
            if (wrapValue != null && !wrapValue.isExpired() && Objects.equals(wrapValue.value, value)) {
                this.notifyListener(k, wrapValue.value, RemovalCause.EXPLICIT);
                this.data.remove(k);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        this.writeLock.lock();
        try {
            ExpiringValue wrapValue = (ExpiringValue)this.data.get(key);
            if (wrapValue != null && !wrapValue.isExpired() && Objects.equals(wrapValue.value, oldValue)) {
                ExpiringValue<V> newWrapValue = new ExpiringValue<V>(newValue);
                ((ExpiringValue)newWrapValue).duration = wrapValue.duration;
                ((ExpiringValue)newWrapValue).expireAt = wrapValue.expireAt;
                if (!Objects.equals(newValue, wrapValue.value)) {
                    this.notifyListener(key, wrapValue.value, RemovalCause.REPLACED);
                }
                this.data.put(key, newWrapValue);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V replace(K key, V value) {
        this.writeLock.lock();
        try {
            ExpiringValue<V> wrapValue = (ExpiringValue<V>)this.data.get(key);
            if (wrapValue != null && !wrapValue.isExpired()) {
                ExpiringValue<V> newWrapValue = new ExpiringValue<V>(value);
                ((ExpiringValue)newWrapValue).duration = ((ExpiringValue)wrapValue).duration;
                ((ExpiringValue)newWrapValue).expireAt = ((ExpiringValue)wrapValue).expireAt;
                wrapValue = this.data.put(key, newWrapValue);
                if (wrapValue != null) {
                    if (!Objects.equals(((ExpiringValue)wrapValue).value, value)) {
                        this.notifyListener(key, ((ExpiringValue)wrapValue).value, RemovalCause.REPLACED);
                    }
                    Object object = ((ExpiringValue)wrapValue).value;
                    return (V)object;
                }
            }
            V v = null;
            return v;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V replace(K key, V value, long duration, TimeUnit timeUnit) {
        this.writeLock.lock();
        try {
            ExpiringValue<V> newWrapValue;
            ExpiringValue<V> wrapValue = (ExpiringValue<V>)this.data.get(key);
            if (wrapValue != null && !wrapValue.isExpired() && (wrapValue = this.data.put(key, newWrapValue = new ExpiringValue<V>(value, duration, timeUnit))) != null) {
                if (!Objects.equals(((ExpiringValue)wrapValue).value, value)) {
                    this.notifyListener(key, ((ExpiringValue)wrapValue).value, RemovalCause.REPLACED);
                }
                Object object = ((ExpiringValue)wrapValue).value;
                return (V)object;
            }
            V v = null;
            return v;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    private V putIfAbsent(K key, ExpiringValue<V> wrapValue) {
        this.writeLock.lock();
        try {
            ExpiringValue<V> preVal = this.data.putIfAbsent(key, wrapValue);
            if (preVal == null) {
                V v = null;
                return v;
            }
            if (((ExpiringValue)preVal).expireAt < System.currentTimeMillis()) {
                this.data.put(key, wrapValue);
                if (!Objects.equals(((ExpiringValue)wrapValue).value, ((ExpiringValue)preVal).value)) {
                    this.notifyListener(key, ((ExpiringValue)preVal).value, RemovalCause.EXPIRED);
                }
                V v = null;
                return v;
            }
            Object object = ((ExpiringValue)preVal).value;
            return (V)object;
        }
        finally {
            this.writeLock.unlock();
            this.record();
        }
    }

    private void record() {
        this.accumulate.getAndIncrement();
        this.checkAccumulate();
    }

    private void accessRecord(ExpiringValue<V> value) {
        if (this.expiringPolicy == ExpiringPolicy.ACCESSED) {
            ((ExpiringValue)value).expireAt = System.currentTimeMillis() + ((ExpiringValue)value).duration;
        }
    }

    private void checkAccumulate() {
        if (this.cleanPolicy == CleanPolicy.ACCUMULATE && this.accumulate.get() % (long)this.accumulateThreshold == 0L) {
            this.runAccumulateCleanPolicy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expiredClean() {
        this.writeLock.lock();
        try {
            Iterator it = this.data.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (!((ExpiringValue)entry.getValue()).isExpired()) continue;
                Object key = entry.getKey();
                Object value = ((ExpiringValue)entry.getValue()).value;
                it.remove();
                this.notifyListenerSync(key, value, RemovalCause.EXPIRED);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void notifyListenerSync(K key, V value, RemovalCause cause) {
        if (this.asyncExpiredListeners != null && !this.asyncExpiredListeners.isEmpty()) {
            for (ExpiredListener<K, V> listener : this.asyncExpiredListeners) {
                listener.expire(key, value, cause);
            }
        }
    }

    private void notifyListener(K key, V value, RemovalCause cause) {
        ThreadUtils.globalPool().execute(() -> this.notifyListenerSync(key, value, cause));
    }

    private void runScheduleCleanPolicy() {
        int size = this.realSize();
        if (log.isDebugEnabled() && size > 0) {
            log.debug("scheduled clean [{}] and now realSize is [{}]", (Object)this.name, (Object)size);
        }
        this.expiredClean();
    }

    private void runAccumulateCleanPolicy() {
        int size = this.realSize();
        if (log.isDebugEnabled() && size > 0) {
            log.debug("accumulate clean [{}] and now realSize is [{}]", (Object)this.name, (Object)size);
        }
        ThreadUtils.globalPool().execute(this::expiredClean);
    }

    public String getName() {
        return this.name;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public long getDuration() {
        return this.duration;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public ExpiringPolicy getExpiringPolicy() {
        return this.expiringPolicy;
    }

    public CleanPolicy getCleanPolicy() {
        return this.cleanPolicy;
    }

    public int getScheduleDelay() {
        return this.scheduleDelay;
    }

    public int getAccumulateThreshold() {
        return this.accumulateThreshold;
    }

    static final class LruMap<K, V>
    extends LinkedHashMap<K, ExpiringValue<V>> {
        private static final long serialVersionUID = 1L;
        private int maxSize;
        private transient List<ExpiredListener<K, V>> listeners;

        LruMap() {
        }

        LruMap<K, V> maxSize(int maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        LruMap<K, V> listeners(List<ExpiredListener<K, V>> listeners) {
            this.listeners = listeners;
            return this;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, ExpiringValue<V>> eldest) {
            boolean b;
            boolean bl = b = this.maxSize > 0 && this.maxSize < super.size();
            if (b && this.listeners != null) {
                for (ExpiredListener<K, Object> expiredListener : this.listeners) {
                    expiredListener.expire(eldest.getKey(), ((ExpiringValue)eldest.getValue()).value, RemovalCause.SIZE);
                }
            }
            return b;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LruMap)) {
                return false;
            }
            LruMap other = (LruMap)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            return this.maxSize == other.maxSize;
        }

        protected boolean canEqual(Object other) {
            return other instanceof LruMap;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            result = result * 59 + this.maxSize;
            return result;
        }
    }

    static final class MapEntry<K, V>
    implements Map.Entry<K, V> {
        K key;
        V value;

        MapEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V pre = this.value;
            this.value = value;
            return pre;
        }
    }

    private static final class ExpiringValue<V> {
        private static final long NOT_EXPIRED = -1L;
        private final V value;
        private long expireAt;
        private long duration;

        ExpiringValue(V value) {
            this.value = value;
            this.expireAt = -1L;
        }

        ExpiringValue(V value, long duration, TimeUnit timeUnit) {
            this.value = value;
            if (duration > 0L) {
                this.duration = timeUnit.toMillis(duration);
                this.expireAt = System.currentTimeMillis() + this.duration;
            } else {
                this.expireAt = -1L;
            }
        }

        boolean isExpired() {
            return this.expireAt != -1L && this.expireAt < System.currentTimeMillis();
        }
    }

    public static final class Builder<K, V> {
        private List<ExpiredListener<K, V>> asyncExpiredListeners;
        private int maxSize = Integer.MAX_VALUE;
        private long duration = -1L;
        private TimeUnit timeUnit = TimeUnit.SECONDS;
        private ExpiringPolicy expiringPolicy = ExpiringPolicy.CREATED;
        private CleanPolicy cleanPolicy = CleanPolicy.ACCUMULATE;
        private int scheduleDelay = -1;
        private int accumulateThreshold = 10000;
        private String name;

        private Builder() {
        }

        public Builder<K, V> name(String name) {
            this.name = name;
            return this;
        }

        public Builder<K, V> maxSize(int maxSize) {
            if (maxSize <= 0) {
                throw new IllegalArgumentException("[maxSize] should be positive");
            }
            this.maxSize = maxSize;
            return this;
        }

        public Builder<K, V> asyncExpiredListeners(ExpiredListener<K, V> listener) {
            MoreObjects.notNull(listener, "[listener] can not be null");
            if (this.asyncExpiredListeners == null) {
                this.asyncExpiredListeners = new ArrayList<ExpiredListener<K, V>>();
            }
            this.asyncExpiredListeners.add(listener);
            return this;
        }

        public Builder<K, V> asyncExpiredListeners(List<ExpiredListener<K, V>> listeners) {
            MoreObjects.notNull(listeners, "[listeners] can not be null");
            this.asyncExpiredListeners = listeners;
            return this;
        }

        public Builder<K, V> expiration(long duration, TimeUnit timeUnit) {
            if (duration <= 0L) {
                throw new IllegalArgumentException("[duration] should be positive");
            }
            MoreObjects.notNull(timeUnit, "[timeUnit] can not be null");
            this.duration = duration;
            this.timeUnit = timeUnit;
            return this;
        }

        public Builder<K, V> expiringPolicy(ExpiringPolicy expiringPolicy) {
            MoreObjects.notNull(expiringPolicy, "[expiringPolicy] can not be null");
            this.expiringPolicy = expiringPolicy;
            return this;
        }

        public Builder<K, V> cleanPolicy(CleanPolicy cleanPolicy) {
            MoreObjects.notNull(cleanPolicy, "[cleanPolicy] can not be null");
            this.cleanPolicy = cleanPolicy;
            return this;
        }

        public Builder<K, V> scheduleDelay(int scheduleDelay) {
            if (scheduleDelay <= 0) {
                throw new IllegalArgumentException("[scheduleDelay] should be positive");
            }
            this.scheduleDelay = scheduleDelay;
            return this;
        }

        public Builder<K, V> accumulateThreshold(int accumulateThreshold) {
            if (accumulateThreshold <= 0) {
                throw new IllegalArgumentException("[accumulateThreshold] should be positive");
            }
            this.accumulateThreshold = accumulateThreshold;
            return this;
        }

        public ExpiringMap<K, V> build() {
            return new ExpiringMap(this);
        }
    }

    @FunctionalInterface
    public static interface ExpiredListener<K, V> {
        public void expire(K var1, V var2, RemovalCause var3);
    }

    public static enum RemovalCause {
        EXPLICIT,
        REPLACED,
        EXPIRED,
        SIZE;

    }

    public static enum CleanPolicy {
        SCHEDULE,
        ACCUMULATE;

    }

    public static enum ExpiringPolicy {
        CREATED,
        ACCESSED;

    }
}

