/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Properties;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vip.justlive.oxygen.core.Bootstrap;
import vip.justlive.oxygen.core.config.ConfigFactory;
import vip.justlive.oxygen.core.exception.Exceptions;
import vip.justlive.oxygen.core.net.http.HttpRequest;
import vip.justlive.oxygen.core.net.http.HttpResponse;
import vip.justlive.oxygen.core.util.IoUtils;
import vip.justlive.oxygen.core.util.MoreObjects;
import vip.justlive.oxygen.core.util.SnowflakeIdWorker;

public final class FileUtils {
    private static final Logger log = LoggerFactory.getLogger(FileUtils.class);
    private static final Properties MIME_TYPES = new Properties();

    public static void mkdirs(File dir) {
        if (dir == null) {
            return;
        }
        if (dir.exists()) {
            log.info("mkdirs [{}] exists", (Object)dir);
        } else {
            if (!dir.mkdirs()) {
                throw Exceptions.fail("create dir fail");
            }
            log.info("mkdirs [{}] successfully", (Object)dir);
        }
    }

    public static void mkdirs(Path path) {
        if (path == null) {
            return;
        }
        FileUtils.mkdirs(path.toFile());
    }

    public static void mkdirs(String path) {
        if (path == null) {
            return;
        }
        FileUtils.mkdirs(new File(path));
    }

    public static void mkdirs(String parent, String ... children) {
        MoreObjects.notNull(parent);
        File parentDir = new File(parent);
        if (children != null && children.length > 0) {
            for (String child : children) {
                parentDir = new File(parentDir, child);
            }
        }
        FileUtils.mkdirs(parentDir);
    }

    public static void mkdirsForFile(File file) {
        if (file == null) {
            return;
        }
        File dir = file.getParentFile();
        if (dir != null && !dir.exists()) {
            FileUtils.mkdirs(dir);
        }
    }

    public static void touch(File file) {
        if (file == null) {
            return;
        }
        if (!file.exists()) {
            FileUtils.mkdirsForFile(file);
            try {
                if (!file.createNewFile()) {
                    throw Exceptions.fail("touch file fail");
                }
                log.info("file [{}] created", (Object)file);
            }
            catch (IOException e) {
                throw Exceptions.wrap(e);
            }
        } else {
            log.info("file [{}] exists", (Object)file);
        }
    }

    public static void touch(Path path) {
        if (path == null) {
            return;
        }
        FileUtils.touch(path.toFile());
    }

    public static void touch(String filepath) {
        if (filepath == null) {
            return;
        }
        FileUtils.touch(new File(filepath));
    }

    public static String extension(String filename) {
        int index = MoreObjects.notNull(filename).lastIndexOf(".");
        if (index == -1) {
            return "";
        }
        return filename.substring(index + 1);
    }

    public static int countFiles(File file) {
        return FileUtils.countFiles(file, MoreObjects.alwaysTrue());
    }

    public static int countFiles(File file, Predicate<File> filter) {
        MoreObjects.notNull(file, "file cant not be null");
        MoreObjects.notNull(filter, "filter can not be null");
        if (file.isFile()) {
            if (filter.test(file)) {
                return 1;
            }
            return 0;
        }
        File[] files = file.listFiles();
        if (files == null || files.length == 0) {
            return 0;
        }
        int count = 0;
        for (File child : files) {
            count += FileUtils.countFiles(child, filter);
        }
        return count;
    }

    public static int countDirs(File file) {
        return FileUtils.countDirs(file, MoreObjects.alwaysTrue());
    }

    public static int countDirs(File file, Predicate<File> filter) {
        MoreObjects.notNull(file, "file cant not be null");
        MoreObjects.notNull(filter, "filter can not be null");
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files == null || files.length == 0) {
                if (filter.test(file)) {
                    return 1;
                }
                return 0;
            }
            int count = 1;
            for (File child : files) {
                count += FileUtils.countDirs(child, filter);
            }
            return count;
        }
        return 0;
    }

    public static String absolutePath(File file) {
        MoreObjects.notNull(file);
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            return file.getAbsolutePath();
        }
    }

    public static boolean isSamePath(File file, File another) {
        if (file == another || file.equals(another)) {
            return true;
        }
        return FileUtils.absolutePath(file).equals(FileUtils.absolutePath(another));
    }

    public static boolean isRoot(File dir) {
        if (dir == null || !dir.isDirectory()) {
            return false;
        }
        for (File file : File.listRoots()) {
            if (!FileUtils.isSamePath(file, dir)) continue;
            return true;
        }
        return false;
    }

    public static int delete(File file) {
        if (file != null && file.exists()) {
            if (file.isFile()) {
                return FileUtils.deleteFile(file);
            }
            return FileUtils.deleteDir(file);
        }
        return 0;
    }

    public static int deleteFile(File file) {
        if (file != null && file.isFile()) {
            return FileUtils.deletePath(file.toPath());
        }
        return 0;
    }

    public static int deleteDir(File file) {
        if (file != null && file.isDirectory()) {
            File[] files = file.listFiles();
            int count = 0;
            if (files != null && files.length > 0) {
                for (File subFile : files) {
                    if (subFile.isFile()) {
                        count += FileUtils.deleteFile(subFile);
                        continue;
                    }
                    count += FileUtils.deleteDir(subFile);
                }
            }
            return count += FileUtils.deletePath(file.toPath());
        }
        return 0;
    }

    public static File tempDir() {
        String tempDir = ConfigFactory.getProperty("main.temp.dir");
        if (tempDir == null || tempDir.trim().length() == 0) {
            try {
                tempDir = System.getProperty("java.io.tmpdir");
            }
            catch (Exception e) {
                tempDir = ".oxygen";
            }
        }
        return new File(tempDir);
    }

    public static File tempBaseDir() {
        return new File(FileUtils.tempDir(), Bootstrap.version());
    }

    public static int cleanTempBaseDir() {
        return FileUtils.deleteDir(FileUtils.tempBaseDir());
    }

    public static File createTempDir(String first, String ... children) {
        File dir = new File(FileUtils.tempBaseDir(), first);
        if (children.length > 0) {
            for (String child : children) {
                dir = new File(dir, child);
            }
        }
        if (dir.isDirectory()) {
            return dir;
        }
        if (dir.exists()) {
            throw Exceptions.fail("the existed file is not directory: " + first);
        }
        FileUtils.mkdirs(dir);
        return dir;
    }

    public static String parseMimeType(String filename) {
        return FileUtils.getMimeType(FileUtils.extension(filename));
    }

    public static String getMimeType(String extension) {
        return MIME_TYPES.getProperty(extension);
    }

    public static File download(String url) throws IOException {
        File file = new File(FileUtils.tempBaseDir(), SnowflakeIdWorker.defaultNextId() + "." + FileUtils.extension(url));
        FileUtils.download(url, file);
        return file;
    }

    public static void download(String url, File file) throws IOException {
        try (HttpResponse response = HttpRequest.get(url).execute();
             FileOutputStream out = new FileOutputStream(file);){
            IoUtils.copy(response.getBody(), out);
        }
    }

    private static int deletePath(Path path) {
        try {
            Files.delete(path);
            return 1;
        }
        catch (IOException e) {
            log.warn("delete file error", (Throwable)e);
            return 0;
        }
    }

    private FileUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        try {
            MIME_TYPES.load(FileUtils.class.getResourceAsStream("/mime-types.properties"));
        }
        catch (IOException e) {
            log.warn("mime types initial failed ", (Throwable)e);
        }
    }
}

