/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import vip.justlive.oxygen.core.util.KeyLock;

public class LocalKeyLock
implements KeyLock {
    private final Map<String, Lock> locks = new ConcurrentHashMap<String, Lock>(4);

    @Override
    public boolean tryLock(String key) {
        return this.getLock(key).tryLock();
    }

    @Override
    public boolean tryLock(String key, long expire) {
        return this.tryLock(key);
    }

    @Override
    public boolean tryLock(String key, long timeout, TimeUnit unit) {
        try {
            return this.getLock(key).tryLock(timeout, unit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    @Override
    public boolean tryLock(String key, long expire, long timeout, TimeUnit unit) {
        return this.tryLock(key, timeout, unit);
    }

    @Override
    public void lock(String key) {
        this.getLock(key).lock();
    }

    @Override
    public void lock(String key, long expire) {
        this.lock(key);
    }

    @Override
    public void unlock(String key) {
        Lock lock = this.locks.get(key);
        if (lock != null) {
            lock.unlock();
        }
    }

    private Lock getLock(String key) {
        return this.locks.computeIfAbsent(key, k -> new ReentrantLock());
    }
}

