/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.util;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import vip.justlive.oxygen.core.exception.Exceptions;
import vip.justlive.oxygen.core.util.RateLimiter;
import vip.justlive.oxygen.core.util.ThreadUtils;

public class LocalRateLimiter
implements RateLimiter {
    private static final ScheduledExecutorService POOL = ThreadUtils.newScheduledExecutor(10, "rate-limiter-%d");
    private final Map<String, Resource> resources = new ConcurrentHashMap<String, Resource>(4);

    @Override
    public void setRate(String key, long rate, long interval) {
        if (!this.resources.containsKey(key)) {
            this.resources.putIfAbsent(key, new Resource(rate, interval));
        }
    }

    @Override
    public boolean tryAcquire(String key, long permits) {
        if (permits > this.get(key).rate) {
            throw Exceptions.fail("Requested permits amount could not exceed defined rate");
        }
        return this.sync(key, permits) == null;
    }

    @Override
    public boolean tryAcquire(String key, long permits, long timeout, TimeUnit unit) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        this.tryAcquireAsync(key, permits, unit.toMillis(timeout), future);
        return future.join();
    }

    @Override
    public void acquire(String key, long permits) {
        this.tryAcquire(key, permits, 0L, TimeUnit.MILLISECONDS);
    }

    private void tryAcquireAsync(String key, long permits, long timeout, CompletableFuture<Boolean> future) {
        long current = System.currentTimeMillis();
        CompletableFuture.supplyAsync(() -> this.sync(key, permits), POOL).whenComplete((res, e) -> {
            if (e != null) {
                future.completeExceptionally((Throwable)e);
                return;
            }
            if (res == null) {
                future.complete(Boolean.TRUE);
                return;
            }
            if (timeout <= 0L) {
                POOL.schedule(() -> this.tryAcquireAsync(key, permits, timeout, future), (long)res, TimeUnit.MILLISECONDS);
                return;
            }
            long el = System.currentTimeMillis() - current;
            long remains = timeout - el;
            if (remains <= 0L) {
                future.complete(Boolean.FALSE);
                return;
            }
            if (remains < res) {
                POOL.schedule(() -> future.complete(Boolean.FALSE), remains, TimeUnit.MILLISECONDS);
                return;
            }
            long start = System.currentTimeMillis();
            POOL.schedule(() -> {
                long elapsed = System.currentTimeMillis() - start;
                if (remains <= elapsed) {
                    future.complete(Boolean.FALSE);
                    return;
                }
                this.tryAcquireAsync(key, permits, remains - elapsed, future);
            }, (long)res, TimeUnit.MILLISECONDS);
        });
    }

    protected Long sync(String key, long permits) {
        return this.get(key).sync(permits);
    }

    private Resource get(String key) {
        Resource resource = this.resources.get(key);
        if (resource == null) {
            throw Exceptions.fail("RateLimiter is not initialized");
        }
        return resource;
    }

    private static class Resource {
        private final long rate;
        private final long interval;
        private long start;
        private long state;

        synchronized Long sync(long permits) {
            long now = System.currentTimeMillis();
            long res = now - this.start;
            if (res > this.interval) {
                this.start = now;
                this.state = 0L;
                res = 0L;
            }
            if (this.state + permits <= this.rate) {
                this.state += permits;
                return null;
            }
            return this.interval - res;
        }

        public Resource(long rate, long interval) {
            this.rate = rate;
            this.interval = interval;
        }

        public long getRate() {
            return this.rate;
        }

        public long getInterval() {
            return this.interval;
        }

        public long getStart() {
            return this.start;
        }

        public long getState() {
            return this.state;
        }

        public void setStart(long start) {
            this.start = start;
        }

        public void setState(long state) {
            this.state = state;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Resource)) {
                return false;
            }
            Resource other = (Resource)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getRate() != other.getRate()) {
                return false;
            }
            if (this.getInterval() != other.getInterval()) {
                return false;
            }
            if (this.getStart() != other.getStart()) {
                return false;
            }
            return this.getState() == other.getState();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Resource;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $rate = this.getRate();
            result = result * 59 + (int)($rate >>> 32 ^ $rate);
            long $interval = this.getInterval();
            result = result * 59 + (int)($interval >>> 32 ^ $interval);
            long $start = this.getStart();
            result = result * 59 + (int)($start >>> 32 ^ $start);
            long $state = this.getState();
            result = result * 59 + (int)($state >>> 32 ^ $state);
            return result;
        }

        public String toString() {
            return "LocalRateLimiter.Resource(rate=" + this.getRate() + ", interval=" + this.getInterval() + ", start=" + this.getStart() + ", state=" + this.getState() + ")";
        }
    }
}

