/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vip.justlive.oxygen.core.exception.Exceptions;
import vip.justlive.oxygen.core.util.CaughtConsumer;
import vip.justlive.oxygen.core.util.ClassUtils;
import vip.justlive.oxygen.core.util.Urls;

public final class MoreObjects {
    private static final Logger log = LoggerFactory.getLogger(MoreObjects.class);

    public static <T> T notNull(T obj) {
        return MoreObjects.notNull(obj, "can not be null");
    }

    public static <T> T notNull(T obj, String msg) {
        if (obj == null) {
            throw Exceptions.fail(msg);
        }
        return obj;
    }

    public static <T> T firstOrNull(T first, T second) {
        if (first != null) {
            return first;
        }
        return second;
    }

    public static <T> T firstNonNull(T first, T second) {
        T obj = MoreObjects.firstOrNull(first, second);
        if (obj != null) {
            return obj;
        }
        throw new IllegalArgumentException();
    }

    public static Map<String, Object> beanToMap(Object bean) {
        MoreObjects.notNull(bean, "bean can not be null");
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        if (Map.class.isAssignableFrom(bean.getClass())) {
            Map beanMap = (Map)bean;
            beanMap.forEach((k, v) -> map.put(k.toString(), v));
        } else {
            for (Field field : ClassUtils.getAllDeclaredFields(bean.getClass())) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                field.setAccessible(true);
                try {
                    Object value = field.get(bean);
                    if (value == null) continue;
                    map.put(field.getName(), value);
                }
                catch (IllegalAccessException e) {
                    log.warn("field can not get value", (Throwable)e);
                }
            }
        }
        return map;
    }

    public static String beanToQueryString(Object bean) {
        return MoreObjects.beanToQueryString(bean, false);
    }

    public static String beanToQueryString(Object bean, boolean urlEncoded) {
        Map<String, Object> map = MoreObjects.beanToMap(bean);
        StringBuilder sb = new StringBuilder();
        map.forEach((k, v) -> sb.append("&").append((String)k).append("=").append(urlEncoded ? Urls.urlEncode(v.toString()) : v));
        if (sb.length() > 0) {
            sb.deleteCharAt(0);
        }
        return sb.toString();
    }

    public static <T> Predicate<T> alwaysTrue() {
        return t -> true;
    }

    public static <T> Predicate<T> alwaysFalse() {
        return t -> false;
    }

    public static String safeToString(Object obj) {
        if (obj == null) {
            return "";
        }
        return obj.toString();
    }

    public static <T> void caughtForeach(Iterable<T> iterable, Consumer<? super T> consumer) {
        if (consumer instanceof CaughtConsumer) {
            iterable.forEach(consumer);
        } else {
            iterable.forEach(new CaughtConsumer<T>(consumer));
        }
    }

    public static <K, V> Map<K, V> mapOf() {
        return new HashMap(2);
    }

    public static <K, V> Map<K, V> mapOf(K k, V v) {
        Map<K, V> map = MoreObjects.mapOf();
        map.put(MoreObjects.notNull(k), v);
        return map;
    }

    public static <K, V> Map<K, V> mapOf(K k1, V v1, K k2, V v2) {
        Map<K, V> map = MoreObjects.mapOf();
        map.put(MoreObjects.notNull(k1), v1);
        map.put(MoreObjects.notNull(k2), v2);
        return map;
    }

    public static <K, V> Map<K, V> mapOf(K k1, V v1, K k2, V v2, K k3, V v3) {
        Map<K, V> map = MoreObjects.mapOf();
        map.put(MoreObjects.notNull(k1), v1);
        map.put(MoreObjects.notNull(k2), v2);
        map.put(MoreObjects.notNull(k3), v3);
        return map;
    }

    @SafeVarargs
    public static <T> Set<T> intersection(Set<T> first, Set<T> second, Set<T> ... others) {
        HashSet<T> intersection = new HashSet<T>();
        for (T obj : first) {
            if (!second.contains(obj)) continue;
            intersection.add(obj);
        }
        if (others == null) {
            return intersection;
        }
        for (Set<T> other : others) {
            intersection.retainAll(other);
        }
        return intersection;
    }

    @SafeVarargs
    public static <T> Set<T> union(Set<T> first, Set<T> second, Set<T> ... others) {
        HashSet<T> union = new HashSet<T>(first);
        union.addAll(second);
        if (others == null) {
            return union;
        }
        for (Set<T> other : others) {
            union.addAll(other);
        }
        return union;
    }

    public static Executor directExecutor() {
        return Runnable::run;
    }

    private MoreObjects() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

