/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.util;

import java.io.Serializable;
import java.util.List;

public class Page<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Integer pageIndex;
    private Integer pageSize;
    private Long totalNumber;
    private List<T> items;
    private Integer totalPage;
    private Integer preIndex;
    private Integer nextIndex;

    public Page(Integer pageIndex, Integer pageSize, Long totalNumber, List<T> items) {
        this.pageIndex = pageIndex;
        this.pageSize = pageSize;
        this.totalNumber = totalNumber;
        this.items = items;
        this.compute();
    }

    private void compute() {
        if (this.pageSize != null && this.pageSize > 0) {
            long page = this.totalNumber / (long)this.pageSize.intValue();
            if (this.totalNumber % (long)this.pageSize.intValue() != 0L) {
                ++page;
            }
            this.totalPage = (int)page;
            this.preIndex = Math.max(1, this.pageIndex - 1);
            this.nextIndex = Math.min(this.pageIndex + 1, this.totalPage);
        }
    }

    public Integer getPageIndex() {
        return this.pageIndex;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public Long getTotalNumber() {
        return this.totalNumber;
    }

    public List<T> getItems() {
        return this.items;
    }

    public Integer getTotalPage() {
        return this.totalPage;
    }

    public Integer getPreIndex() {
        return this.preIndex;
    }

    public Integer getNextIndex() {
        return this.nextIndex;
    }

    public void setPageIndex(Integer pageIndex) {
        this.pageIndex = pageIndex;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public void setTotalNumber(Long totalNumber) {
        this.totalNumber = totalNumber;
    }

    public void setItems(List<T> items) {
        this.items = items;
    }

    public void setTotalPage(Integer totalPage) {
        this.totalPage = totalPage;
    }

    public void setPreIndex(Integer preIndex) {
        this.preIndex = preIndex;
    }

    public void setNextIndex(Integer nextIndex) {
        this.nextIndex = nextIndex;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Page)) {
            return false;
        }
        Page other = (Page)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$pageIndex = this.getPageIndex();
        Integer other$pageIndex = other.getPageIndex();
        if (this$pageIndex == null ? other$pageIndex != null : !((Object)this$pageIndex).equals(other$pageIndex)) {
            return false;
        }
        Integer this$pageSize = this.getPageSize();
        Integer other$pageSize = other.getPageSize();
        if (this$pageSize == null ? other$pageSize != null : !((Object)this$pageSize).equals(other$pageSize)) {
            return false;
        }
        Long this$totalNumber = this.getTotalNumber();
        Long other$totalNumber = other.getTotalNumber();
        if (this$totalNumber == null ? other$totalNumber != null : !((Object)this$totalNumber).equals(other$totalNumber)) {
            return false;
        }
        List<T> this$items = this.getItems();
        List<T> other$items = other.getItems();
        if (this$items == null ? other$items != null : !((Object)this$items).equals(other$items)) {
            return false;
        }
        Integer this$totalPage = this.getTotalPage();
        Integer other$totalPage = other.getTotalPage();
        if (this$totalPage == null ? other$totalPage != null : !((Object)this$totalPage).equals(other$totalPage)) {
            return false;
        }
        Integer this$preIndex = this.getPreIndex();
        Integer other$preIndex = other.getPreIndex();
        if (this$preIndex == null ? other$preIndex != null : !((Object)this$preIndex).equals(other$preIndex)) {
            return false;
        }
        Integer this$nextIndex = this.getNextIndex();
        Integer other$nextIndex = other.getNextIndex();
        return !(this$nextIndex == null ? other$nextIndex != null : !((Object)this$nextIndex).equals(other$nextIndex));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Page;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $pageIndex = this.getPageIndex();
        result = result * 59 + ($pageIndex == null ? 43 : ((Object)$pageIndex).hashCode());
        Integer $pageSize = this.getPageSize();
        result = result * 59 + ($pageSize == null ? 43 : ((Object)$pageSize).hashCode());
        Long $totalNumber = this.getTotalNumber();
        result = result * 59 + ($totalNumber == null ? 43 : ((Object)$totalNumber).hashCode());
        List<T> $items = this.getItems();
        result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
        Integer $totalPage = this.getTotalPage();
        result = result * 59 + ($totalPage == null ? 43 : ((Object)$totalPage).hashCode());
        Integer $preIndex = this.getPreIndex();
        result = result * 59 + ($preIndex == null ? 43 : ((Object)$preIndex).hashCode());
        Integer $nextIndex = this.getNextIndex();
        result = result * 59 + ($nextIndex == null ? 43 : ((Object)$nextIndex).hashCode());
        return result;
    }

    public String toString() {
        return "Page(pageIndex=" + this.getPageIndex() + ", pageSize=" + this.getPageSize() + ", totalNumber=" + this.getTotalNumber() + ", items=" + this.getItems() + ", totalPage=" + this.getTotalPage() + ", preIndex=" + this.getPreIndex() + ", nextIndex=" + this.getNextIndex() + ")";
    }

    public Page() {
    }
}

