/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.util;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vip.justlive.oxygen.core.util.SplitterMatcher;
import vip.justlive.oxygen.core.util.Strings;

public final class PathMatcher {
    private static final Logger log = LoggerFactory.getLogger(PathMatcher.class);
    private static final SplitterMatcher MATCHER = new SplitterMatcher('/');

    public static boolean match(String pattern, String path) {
        return MATCHER.match(pattern, path);
    }

    public static String getRootDir(String location) {
        int prefixEnd = location.indexOf(":") + 1;
        int rootDirEnd = location.length();
        while (rootDirEnd > prefixEnd && Strings.isPattern(location.substring(prefixEnd, rootDirEnd))) {
            rootDirEnd = location.lastIndexOf("/", rootDirEnd - 2) + 1;
        }
        if (rootDirEnd == 0) {
            rootDirEnd = prefixEnd;
        }
        return location.substring(0, rootDirEnd);
    }

    public static Set<File> findMatchedFiles(File rootDir, String subPattern) {
        LinkedHashSet<File> files = new LinkedHashSet<File>();
        if (!(rootDir.exists() && rootDir.isDirectory() && rootDir.canRead())) {
            if (log.isWarnEnabled()) {
                log.warn("dir [{}] cannot execute search operation", (Object)rootDir.getPath());
            }
            return files;
        }
        String fullPattern = rootDir.getAbsolutePath().replace(File.separator, "/");
        if (!subPattern.startsWith("/")) {
            fullPattern = fullPattern + "/";
        }
        fullPattern = fullPattern + subPattern.replace(File.separator, "/");
        PathMatcher.searchMatchedFiles(fullPattern, rootDir, files);
        return files;
    }

    private static void searchMatchedFiles(String fullPattern, File dir, Set<File> files) {
        File[] dirContents;
        if (log.isDebugEnabled()) {
            log.debug("search files under dir [{}]", (Object)dir);
        }
        if ((dirContents = dir.listFiles()) == null) {
            return;
        }
        for (File content : dirContents) {
            String currentPath = content.getAbsolutePath().replace(File.separator, "/");
            if (content.isDirectory()) {
                if (!content.canRead() && log.isDebugEnabled()) {
                    log.debug("dir [{}] has no read permission, skip", (Object)content);
                    continue;
                }
                PathMatcher.searchMatchedFiles(fullPattern, content, files);
                continue;
            }
            if (!PathMatcher.match(fullPattern, currentPath)) continue;
            files.add(content);
        }
    }

    private PathMatcher() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

