/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import vip.justlive.oxygen.core.util.MoreObjects;

public class PlaceHolderHelper {
    public static final String DEFAULT_PLACEHOLDER_PREFIX = "${";
    public static final String DEFAULT_PLACEHOLDER_SUFFIX = "}";
    public static final String DEFAULT_VALUE_SEPARATOR = ":";
    public static final PlaceHolderHelper DEFAULT_HELPER;
    private static final Map<String, String> SIMPLE_PREFIXES;
    private final String placeholderPrefix;
    private final String placeholderSuffix;
    private final String simplePrefix;
    private final String valueSeparator;
    private final boolean ignoreUnresolvablePlaceholders;

    public PlaceHolderHelper(String placeholderPrefix, String placeholderSuffix) {
        this(placeholderPrefix, placeholderSuffix, null, true);
    }

    public PlaceHolderHelper(String placeholderPrefix, String placeholderSuffix, String valueSeparator, boolean ignoreUnresolvablePlaceholders) {
        MoreObjects.notNull(placeholderPrefix, "'placeholderPrefix' must not be null");
        MoreObjects.notNull(placeholderSuffix, "'placeholderSuffix' must not be null");
        this.placeholderPrefix = placeholderPrefix;
        this.placeholderSuffix = placeholderSuffix;
        String simplePrefixForSuffix = SIMPLE_PREFIXES.get(this.placeholderSuffix);
        this.simplePrefix = simplePrefixForSuffix != null && this.placeholderPrefix.endsWith(simplePrefixForSuffix) ? simplePrefixForSuffix : this.placeholderPrefix;
        this.valueSeparator = valueSeparator;
        this.ignoreUnresolvablePlaceholders = ignoreUnresolvablePlaceholders;
    }

    public static PlaceHolderHelper defaultInstance() {
        return DEFAULT_HELPER;
    }

    private static boolean substringMatch(CharSequence str, int index, CharSequence substring) {
        if (index + substring.length() > str.length()) {
            return false;
        }
        for (int i = 0; i < substring.length(); ++i) {
            if (str.charAt(index + i) == substring.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public String replacePlaceholders(String value, Properties properties) {
        MoreObjects.notNull(properties, "'properties' must not be null");
        MoreObjects.notNull(value, "'value' must not be null");
        return this.parseStringValue(value, properties, new HashSet<String>());
    }

    protected String parseStringValue(String value, Properties properties, Set<String> visitedPlaceholders) {
        StringBuilder result = new StringBuilder(value);
        int startIndex = value.indexOf(this.placeholderPrefix);
        while (startIndex != -1) {
            int endIndex = this.findPlaceholderEndIndex(result, startIndex);
            if (endIndex != -1) {
                String placeholder = result.substring(startIndex + this.placeholderPrefix.length(), endIndex);
                String originalPlaceholder = placeholder;
                if (!visitedPlaceholders.add(originalPlaceholder)) {
                    throw new IllegalArgumentException("Circular placeholder reference '" + originalPlaceholder + "' in property definitions");
                }
                placeholder = this.parseStringValue(placeholder, properties, visitedPlaceholders);
                String propVal = properties.getProperty(placeholder);
                if ((propVal = this.getCommonVal(properties, placeholder, propVal)) != null) {
                    propVal = this.parseStringValue(propVal, properties, visitedPlaceholders);
                    result.replace(startIndex, endIndex + this.placeholderSuffix.length(), propVal);
                    startIndex = result.indexOf(this.placeholderPrefix, startIndex + propVal.length());
                } else if (this.ignoreUnresolvablePlaceholders) {
                    startIndex = result.indexOf(this.placeholderPrefix, endIndex + this.placeholderSuffix.length());
                } else {
                    throw new IllegalArgumentException(String.format("Could not resolve placeholder '%s' in value '%s'", placeholder, value));
                }
                visitedPlaceholders.remove(originalPlaceholder);
                continue;
            }
            startIndex = -1;
        }
        return result.toString();
    }

    private String getCommonVal(Properties properties, String placeholder, String propVal) {
        int separatorIndex;
        if (propVal == null && this.valueSeparator != null && (separatorIndex = placeholder.indexOf(this.valueSeparator)) != -1) {
            String actualPlaceholder = placeholder.substring(0, separatorIndex);
            String defaultValue = placeholder.substring(separatorIndex + this.valueSeparator.length());
            propVal = properties.getProperty(actualPlaceholder);
            if (propVal == null) {
                propVal = defaultValue;
            }
        }
        return propVal;
    }

    private int findPlaceholderEndIndex(CharSequence buf, int startIndex) {
        int index = startIndex + this.placeholderPrefix.length();
        int withinNestedPlaceholder = 0;
        while (index < buf.length()) {
            if (PlaceHolderHelper.substringMatch(buf, index, this.placeholderSuffix)) {
                if (withinNestedPlaceholder > 0) {
                    --withinNestedPlaceholder;
                    index += this.placeholderSuffix.length();
                    continue;
                }
                return index;
            }
            if (PlaceHolderHelper.substringMatch(buf, index, this.simplePrefix)) {
                ++withinNestedPlaceholder;
                index += this.simplePrefix.length();
                continue;
            }
            ++index;
        }
        return -1;
    }

    static {
        SIMPLE_PREFIXES = new HashMap<String, String>(4);
        SIMPLE_PREFIXES.put(DEFAULT_PLACEHOLDER_SUFFIX, "{");
        SIMPLE_PREFIXES.put("]", "[");
        SIMPLE_PREFIXES.put(")", "(");
        DEFAULT_HELPER = new PlaceHolderHelper(DEFAULT_PLACEHOLDER_PREFIX, DEFAULT_PLACEHOLDER_SUFFIX, DEFAULT_VALUE_SEPARATOR, true);
    }
}

