/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.util;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepeatRunnable
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(RepeatRunnable.class);
    private static final AtomicInteger COUNT = new AtomicInteger();
    private final CountDownLatch workInitiated = new CountDownLatch(1);
    private final CountDownLatch shutdownInitiated = new CountDownLatch(1);
    private final CountDownLatch shutdownComplete = new CountDownLatch(1);
    private volatile boolean started;
    private int rounds;
    private final String name;
    private final Runnable runnable;

    public RepeatRunnable(Runnable runnable) {
        this("Unnamed-" + COUNT.getAndIncrement(), runnable);
    }

    @Override
    public void run() {
        this.started = true;
        log.info("[{}] starting", (Object)this.name);
        this.workInitiated.countDown();
        try {
            while (this.shutdownInitiated.getCount() > 0L) {
                this.runnable.run();
                ++this.rounds;
            }
        }
        catch (Exception e) {
            log.error("[{}] error due to", (Object)this.name, (Object)e);
        }
        finally {
            this.shutdownComplete.countDown();
        }
        log.info("[{}] stopped", (Object)this.name);
    }

    public void awaitRunning() {
        this.await(this.workInitiated);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        RepeatRunnable repeatRunnable = this;
        synchronized (repeatRunnable) {
            if (this.shutdownInitiated.getCount() > 0L) {
                log.info("[{}] shutting down", (Object)this.name);
                this.shutdownInitiated.countDown();
            }
        }
        if (this.isStarted()) {
            this.await(this.shutdownComplete);
            if (this.shutdownComplete.getCount() == 0L) {
                log.info("[{}] shutdown completed", (Object)this.name);
            }
        }
    }

    public boolean isShutdown() {
        return this.shutdownInitiated.getCount() == 0L || this.shutdownComplete.getCount() == 0L;
    }

    private void await(CountDownLatch latch) {
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public RepeatRunnable(String name, Runnable runnable) {
        this.name = name;
        this.runnable = runnable;
    }

    public boolean isStarted() {
        return this.started;
    }

    public int getRounds() {
        return this.rounds;
    }

    public String getName() {
        return this.name;
    }
}

