/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.util;

import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vip.justlive.oxygen.core.Plugin;
import vip.justlive.oxygen.core.config.ConfigFactory;
import vip.justlive.oxygen.core.config.CoreConf;
import vip.justlive.oxygen.core.exception.Exceptions;
import vip.justlive.oxygen.core.io.AbstractResourceLoader;
import vip.justlive.oxygen.core.io.SourceResource;
import vip.justlive.oxygen.core.util.ClassUtils;

public class ResourceBundle
extends AbstractResourceLoader
implements Plugin {
    private static final Logger log = LoggerFactory.getLogger(ResourceBundle.class);
    private static final Properties PROPS = new Properties();
    private static final Map<String, Properties> I18N = new HashMap<String, Properties>(2);
    private static final ThreadLocal<Locale> LOCALE = ThreadLocal.withInitial(ResourceBundle::defaultLocale);

    public ResourceBundle() {
        this.init();
    }

    public static Locale currentThreadLocale() {
        return LOCALE.get();
    }

    public static void setThreadLocale(Locale locale) {
        LOCALE.set(locale);
    }

    public static void clearThreadLocale() {
        LOCALE.remove();
    }

    public static String getMessage(String key) {
        Locale locale = ResourceBundle.currentThreadLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getMessage(key, locale);
    }

    public static String getMessage(String key, Locale locale) {
        return ResourceBundle.getMessage(key, locale.getLanguage(), locale.getCountry());
    }

    public static String getMessage(String key, String language, String country) {
        Properties props = I18N.get(language + "_" + country);
        String value = null;
        if (props != null) {
            value = props.getProperty(key);
        }
        if (value == null) {
            value = PROPS.getProperty(key);
        }
        return value;
    }

    private static Locale defaultLocale() {
        CoreConf conf = ConfigFactory.load(CoreConf.class);
        if (conf.getI18nDefaultLanguage() != null && conf.getI18nDefaultLanguage().length() > 0 && conf.getI18nDefaultCountry() != null && conf.getI18nDefaultCountry().length() > 0) {
            return new Locale(conf.getI18nDefaultLanguage(), conf.getI18nDefaultCountry());
        }
        return Locale.getDefault();
    }

    @Override
    public void init() {
        this.loader = ClassUtils.getDefaultClassLoader();
        this.ignoreNotFound = true;
    }

    @Override
    public int order() {
        return -2147483643;
    }

    public void load(String ... locations) {
        List<SourceResource> res = this.parse(locations);
        for (SourceResource resource : res) {
            this.resources.add(resource);
            String[] arr = resource.path().split("_");
            try {
                Reader reader = this.getReader(resource);
                Throwable throwable = null;
                try {
                    if (arr.length == 1) {
                        PROPS.load(reader);
                        continue;
                    }
                    if (arr.length == 3) {
                        I18N.computeIfAbsent(arr[1] + "_" + arr[2].substring(0, arr[2].indexOf(".")), k -> new Properties()).load(reader);
                        continue;
                    }
                    log.warn("file [{}] used an illegal name", (Object)resource.path());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    reader.close();
                }
            }
            catch (IOException e) {
                if (this.ignoreNotFound) {
                    log.warn("i18n file cannot find [{}]", (Object)resource.path());
                    continue;
                }
                throw Exceptions.wrap(e);
            }
        }
    }

    @Override
    public void start() {
        CoreConf conf = ConfigFactory.load(CoreConf.class);
        this.load(conf.getI18nPath());
    }

    @Override
    public void stop() {
        PROPS.clear();
        I18N.clear();
    }
}

