/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.util;

import java.util.ArrayList;
import java.util.List;

public class SecurityChecker {
    private final List<Checker> checkers = new ArrayList<Checker>();

    public void checkPermission() {
        this.checkers.forEach(Checker::check);
    }

    public SecurityChecker ownerThread(Thread owner) {
        return this.addChecker(new OwnerThreadChecker(owner));
    }

    public SecurityChecker addChecker(Checker checker) {
        this.checkers.add(checker);
        return this;
    }

    public void clear() {
        this.checkers.clear();
    }

    public SecurityChecker delChecker(Checker checker) {
        this.checkers.remove(checker);
        return this;
    }

    static class OwnerThreadChecker
    implements Checker {
        private final Thread owner;

        @Override
        public void check() {
            if (this.owner != Thread.currentThread()) {
                throw new IllegalStateException("current thread is not the owner");
            }
        }

        public OwnerThreadChecker(Thread owner) {
            this.owner = owner;
        }
    }

    static interface Checker {
        public void check();
    }
}

