/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.util;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vip.justlive.oxygen.core.util.SecurityChecker;

public class SecurityThreadPoolExecutor
extends ThreadPoolExecutor {
    private static final Logger log = LoggerFactory.getLogger(SecurityThreadPoolExecutor.class);
    private final AtomicInteger submittedCount = new AtomicInteger(0);
    private SecurityChecker securityChecker;

    public SecurityThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
    }

    public SecurityThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
    }

    public SecurityThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, handler);
    }

    public SecurityThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
    }

    @Override
    public void execute(Runnable command) {
        this.submittedCount.incrementAndGet();
        try {
            super.execute(command);
        }
        catch (RejectedExecutionException e) {
            if (this.getQueue() instanceof PoolQueue && this.getQueue().offer(command)) {
                return;
            }
            this.submittedCount.decrementAndGet();
            throw e;
        }
    }

    @Override
    public void shutdown() {
        if (this.securityChecker != null) {
            this.securityChecker.checkPermission();
        }
        super.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        if (this.securityChecker != null) {
            this.securityChecker.checkPermission();
        }
        return super.shutdownNow();
    }

    public int getSubmittedCount() {
        return this.submittedCount.get();
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        this.submittedCount.decrementAndGet();
    }

    public SecurityThreadPoolExecutor setSecurityChecker(SecurityChecker securityChecker) {
        this.securityChecker = securityChecker;
        return this;
    }

    public SecurityChecker getSecurityChecker() {
        return this.securityChecker;
    }

    public static class PoolQueue
    extends LinkedBlockingQueue<Runnable> {
        private static final long serialVersionUID = 5267382526416848275L;
        private transient SecurityThreadPoolExecutor pool;

        PoolQueue(int capacity) {
            super(capacity);
        }

        @Override
        public boolean offer(Runnable runnable) {
            if (this.pool == null) {
                return super.offer(runnable);
            }
            int poolSize = this.pool.getPoolSize();
            if (poolSize >= this.pool.getMaximumPoolSize()) {
                return super.offer(runnable);
            }
            if (this.pool.getSubmittedCount() <= poolSize) {
                return super.offer(runnable);
            }
            if (poolSize < this.pool.getMaximumPoolSize()) {
                return false;
            }
            return super.offer(runnable);
        }

        public PoolQueue() {
        }

        public PoolQueue setPool(SecurityThreadPoolExecutor pool) {
            this.pool = pool;
            return this;
        }
    }
}

