/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;

public final class ServiceLoaderUtils {
    public static <T> T loadService(Class<T> clazz) {
        T service = ServiceLoaderUtils.loadServiceOrNull(clazz);
        if (service == null) {
            throw new IllegalStateException("Cannot find META-INF/services/" + clazz.getName() + " on classpath");
        }
        return service;
    }

    public static <T> T loadServiceOrNull(Class<T> clazz) {
        List<T> services = ServiceLoaderUtils.loadServices(clazz);
        if (services.isEmpty()) {
            return null;
        }
        return (T)services.iterator().next();
    }

    public static <T> List<T> loadServices(Class<T> clazz) {
        return ServiceLoaderUtils.loadServices(clazz, null);
    }

    public static <T> List<T> loadServices(Class<T> clazz, ClassLoader loader) {
        ArrayList list = new ArrayList();
        ServiceLoader<T> serviceLoader = loader != null ? ServiceLoader.load(clazz, loader) : ServiceLoader.load(clazz);
        Iterator<T> it = serviceLoader.iterator();
        if (it.hasNext()) {
            it.forEachRemaining(list::add);
            return list;
        }
        if (loader == null && (it = (serviceLoader = ServiceLoader.load(clazz, ServiceLoaderUtils.class.getClassLoader())).iterator()).hasNext()) {
            it.forEachRemaining(list::add);
            return list;
        }
        return list;
    }

    private ServiceLoaderUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

