/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.util;

import java.util.WeakHashMap;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vip.justlive.oxygen.core.util.Strings;

public class SplitterMatcher {
    private static final Logger log = LoggerFactory.getLogger(SplitterMatcher.class);
    private static final String ANY_REGEX = ".*";
    private static final String DB_ANY_REGEX_TPL = "[%s]?";
    private static final String NOT_SEPARATOR_REGEX_TPL = "[^%s]*";
    private static final WeakHashMap<String, Pattern> PATTERNS = new WeakHashMap(32);
    private final char splitter;
    private final String dbAnyRegex;
    private final String notSeparatorRegex;

    public SplitterMatcher(char splitter) {
        this.splitter = splitter;
        this.dbAnyRegex = String.format(DB_ANY_REGEX_TPL, Character.valueOf(splitter));
        this.notSeparatorRegex = String.format(NOT_SEPARATOR_REGEX_TPL, Character.valueOf(splitter));
    }

    public boolean match(String pattern, String path) {
        boolean fastFail;
        boolean bl = path == null || path.length() > 0 && path.charAt(0) == this.splitter != (pattern.charAt(0) == this.splitter) ? true : (fastFail = false);
        if (fastFail) {
            return false;
        }
        if (Strings.isPattern(pattern)) {
            Pattern p = PATTERNS.get(pattern);
            if (p == null) {
                p = this.parsePattern(pattern);
                PATTERNS.put(pattern, p);
                return p.matcher(path).matches();
            }
            return p.matcher(path).matches();
        }
        return pattern.equals(path);
    }

    private Pattern parsePattern(String pattern) {
        char[] chars = pattern.toCharArray();
        int len = chars.length;
        StringBuilder sb = new StringBuilder();
        boolean pre = false;
        boolean dbPre = false;
        for (int i = 0; i < len; ++i) {
            boolean[] dbp = this.parse(pre, dbPre, chars, i, sb);
            pre = dbp[0];
            dbPre = dbp[1];
        }
        return Pattern.compile(sb.toString());
    }

    private boolean[] parse(boolean pre, boolean dbPre, char[] chars, int i, StringBuilder sb) {
        if (chars[i] == '*') {
            if (pre) {
                sb.append(ANY_REGEX);
                dbPre = true;
            } else if (i + 1 == chars.length) {
                sb.append(this.notSeparatorRegex);
            } else {
                pre = true;
            }
        } else {
            if (dbPre && chars[i] == this.splitter) {
                sb.append(this.dbAnyRegex);
            } else if (!dbPre && pre) {
                sb.append(this.notSeparatorRegex);
            }
            if (chars[i] == '?') {
                sb.append(".");
            } else if (!dbPre || chars[i] != this.splitter) {
                sb.append(chars[i]);
            }
            pre = false;
            dbPre = false;
        }
        return new boolean[]{pre, dbPre};
    }
}

