/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import vip.justlive.oxygen.core.exception.Exceptions;
import vip.justlive.oxygen.core.util.MoreObjects;

public final class Strings {
    public static final String AND = "&";
    public static final String ANY = "*";
    public static final String ANY_PATH = "/*";
    public static final String AT = "@";
    public static final String CLOSE_BRACE = "}";
    public static final String CLOSE_BRACKET = "]";
    public static final String CLOSE_PAREN = ")";
    public static final String COLON = ":";
    public static final String COMMA = ",";
    public static final String DASH = "-";
    public static final String DOLLAR = "$";
    public static final String DOT = ".";
    public static final String DOUBLE_DOLLAR = "$$";
    public static final String DOUBLE_QUOTATION_MARK = "\"";
    public static final String EMPTY = "";
    public static final String EQUAL = "=";
    public static final String OCTOTHORP = "#";
    public static final String OPEN_BRACE = "{";
    public static final String OPEN_BRACKET = "[";
    public static final String OPEN_PAREN = "(";
    public static final String PLUS = "+";
    public static final String QUESTION_MARK = "?";
    public static final String SEMICOLON = ";";
    public static final String SLASH = "/";
    public static final String BACKSLASH = "\\";
    public static final String UNDERSCORE = "_";
    public static final String UNKNOWN = "unknown";
    public static final String FILE_PREFIX = "file:";
    public static final String ALL_CLASSPATH_PREFIX = "classpath*:";
    public static final String CLASSPATH_PREFIX = "classpath:";
    public static final String[] EMPTY_ARRAY = new String[0];

    public static boolean hasText(String text) {
        return text != null && text.trim().length() > 0;
    }

    public static String firstNonNull(String first, String second, String ... others) {
        String str = Strings.firstOrNull(first, second, others);
        if (str != null) {
            return str;
        }
        throw Exceptions.fail("no text have non-empty value");
    }

    public static String firstOrNull(String first, String second, String ... others) {
        if (Strings.hasText(first)) {
            return first;
        }
        if (Strings.hasText(second)) {
            return second;
        }
        if (others != null) {
            for (String str : others) {
                if (!Strings.hasText(str)) continue;
                return str;
            }
        }
        return null;
    }

    public static boolean isPattern(String path) {
        return path.indexOf(42) != -1 || path.indexOf(63) != -1;
    }

    public static float jaccard(String a, String b) {
        Set bChar;
        if (a == null && b == null) {
            return 1.0f;
        }
        if (a == null || b == null) {
            return 0.0f;
        }
        Set aChar = a.chars().boxed().collect(Collectors.toSet());
        int intersection = MoreObjects.intersection(aChar, bChar = b.chars().boxed().collect(Collectors.toSet()), new Set[0]).size();
        if (intersection == 0) {
            return 0.0f;
        }
        int union = MoreObjects.union(aChar, bChar, new Set[0]).size();
        return (float)intersection / (float)union;
    }

    public static float sorensenDice(String a, String b) {
        Set bChars;
        if (a == null && b == null) {
            return 1.0f;
        }
        if (a == null || b == null) {
            return 0.0f;
        }
        Set aChars = a.chars().boxed().collect(Collectors.toSet());
        int intersect = MoreObjects.intersection(aChars, bChars = b.chars().boxed().collect(Collectors.toSet()), new Set[0]).size();
        if (intersect == 0) {
            return 0.0f;
        }
        int aSize = aChars.size();
        int bSize = bChars.size();
        return 2.0f * (float)intersect / (float)(aSize + bSize);
    }

    public static float levenshtein(String a, String b) {
        if (a == null && b == null) {
            return 1.0f;
        }
        if (a == null || b == null) {
            return 0.0f;
        }
        if (a.isEmpty() && b.isEmpty()) {
            return 1.0f;
        }
        return 1.0f - (float)Strings.editDis(a, b) / (float)Math.max(a.length(), b.length());
    }

    public static float hanming(String a, String b) {
        if (a == null || b == null) {
            return 0.0f;
        }
        if (a.length() != b.length()) {
            return 0.0f;
        }
        int disCount = 0;
        for (int i = 0; i < a.length(); ++i) {
            if (a.charAt(i) == b.charAt(i)) continue;
            ++disCount;
        }
        return (float)disCount / (float)a.length();
    }

    public static float cos(String a, String b) {
        if (a == null || b == null) {
            return 0.0f;
        }
        Set aChar = a.chars().boxed().collect(Collectors.toSet());
        Set bChar = b.chars().boxed().collect(Collectors.toSet());
        HashMap<Integer, Integer> aMap = new HashMap<Integer, Integer>(16);
        HashMap<Integer, Integer> bMap = new HashMap<Integer, Integer>(16);
        for (Integer a1 : aChar) {
            aMap.put(a1, aMap.getOrDefault(a1, 0) + 1);
        }
        for (Integer b1 : bChar) {
            bMap.put(b1, bMap.getOrDefault(b1, 0) + 1);
        }
        Set union = MoreObjects.union(aChar, bChar, new Set[0]);
        int[] aVec = new int[union.size()];
        int[] bVec = new int[union.size()];
        ArrayList collect = new ArrayList(union);
        for (int i = 0; i < collect.size(); ++i) {
            aVec[i] = aMap.getOrDefault(collect.get(i), 0);
            bVec[i] = bMap.getOrDefault(collect.get(i), 0);
        }
        int p1 = 0;
        for (int i = 0; i < aVec.length; ++i) {
            p1 += aVec[i] * bVec[i];
        }
        float p2 = 0.0f;
        for (int i : aVec) {
            p2 += (float)(i * i);
        }
        p2 = (float)Math.sqrt(p2);
        float p3 = 0.0f;
        for (int i : bVec) {
            p3 += (float)(i * i);
        }
        return (float)p1 / (p2 * (float)Math.sqrt(p3));
    }

    private static int editDis(String a, String b) {
        int aLen = a.length();
        int bLen = b.length();
        if (aLen == 0 || bLen == 0) {
            return 0;
        }
        int[][] v = new int[aLen + 1][bLen + 1];
        for (int i = 0; i <= aLen; ++i) {
            for (int j = 0; j <= bLen; ++j) {
                v[i][j] = i == 0 ? j : (j == 0 ? i : (a.charAt(i - 1) == b.charAt(j - 1) ? v[i - 1][j - 1] : 1 + Math.min(v[i - 1][j - 1], Math.min(v[i][j - 1], v[i - 1][j]))));
            }
        }
        return v[aLen][bLen];
    }

    private Strings() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

