/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.util;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import vip.justlive.oxygen.core.config.ConfigFactory;
import vip.justlive.oxygen.core.util.SecurityChecker;
import vip.justlive.oxygen.core.util.SecurityThreadPoolExecutor;
import vip.justlive.oxygen.core.util.ThreadFactoryBuilder;
import vip.justlive.oxygen.core.util.timer.WheelTimer;

public final class ThreadUtils {
    private static final ThreadLocal<Map<String, Object>> LOCAL = ThreadLocal.withInitial(HashMap::new);
    private static ThreadFactory threadFactory;
    private static SecurityThreadPoolExecutor globalPool;
    private static WheelTimer globalTimer;

    public static void putVal(String key, Object value) {
        LOCAL.get().put(key, value);
    }

    public static <T> T getVal(String key) {
        return (T)LOCAL.get().get(key);
    }

    public static void clear() {
        LOCAL.remove();
    }

    public static SecurityThreadPoolExecutor newThreadPool(int corePoolSize, int maxPoolSize, int keepAliveSeconds, int queueCapacity, String nameFormat) {
        return ThreadUtils.newThreadPool(corePoolSize, maxPoolSize, keepAliveSeconds, queueCapacity, nameFormat, true);
    }

    public static SecurityThreadPoolExecutor newThreadPool(int corePoolSize, int maxPoolSize, int keepAliveSeconds, int queueCapacity, String nameFormat, boolean daemon) {
        return ThreadUtils.newThreadPool(corePoolSize, maxPoolSize, keepAliveSeconds, queueCapacity, nameFormat, new ThreadPoolExecutor.AbortPolicy(), daemon);
    }

    public static SecurityThreadPoolExecutor newThreadPool(int corePoolSize, int maxPoolSize, int keepAliveSeconds, int queueCapacity, String nameFormat, RejectedExecutionHandler handler) {
        return ThreadUtils.newThreadPool(corePoolSize, maxPoolSize, keepAliveSeconds, queueCapacity, nameFormat, handler, true);
    }

    public static SecurityThreadPoolExecutor newThreadPool(int corePoolSize, int maxPoolSize, int keepAliveSeconds, int queueCapacity, String nameFormat, RejectedExecutionHandler handler, boolean daemon) {
        SecurityThreadPoolExecutor.PoolQueue queue = new SecurityThreadPoolExecutor.PoolQueue(queueCapacity);
        SecurityThreadPoolExecutor pool = new SecurityThreadPoolExecutor(corePoolSize, maxPoolSize, keepAliveSeconds, TimeUnit.SECONDS, queue, new ThreadFactoryBuilder().setNameFormat(nameFormat).setDaemon(daemon).build(), handler);
        queue.setPool(pool);
        return pool;
    }

    public static ScheduledExecutorService newScheduledExecutor(int corePoolSize, String nameFormat) {
        return ThreadUtils.newScheduledExecutor(corePoolSize, nameFormat, new ThreadPoolExecutor.AbortPolicy());
    }

    public static ScheduledExecutorService newScheduledExecutor(int corePoolSize, String nameFormat, RejectedExecutionHandler handler) {
        return new ScheduledThreadPoolExecutor(corePoolSize, new ThreadFactoryBuilder().setNameFormat(nameFormat).setDaemon(true).build(), handler);
    }

    public static void sleep(long millis) {
        ThreadUtils.sleep(millis, TimeUnit.MILLISECONDS);
    }

    public static void sleep(long time, TimeUnit unit) {
        try {
            unit.sleep(time);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static synchronized ThreadFactory defaultThreadFactory() {
        if (threadFactory == null) {
            threadFactory = new ThreadFactoryBuilder().setDaemon(true).setPriority(5).setNameFormat("def-pool-%d").build();
        }
        return threadFactory;
    }

    public static Thread addShutdownHook(Runnable runnable) {
        Thread thread = ThreadUtils.defaultThreadFactory().newThread(runnable);
        Runtime.getRuntime().addShutdownHook(thread);
        return thread;
    }

    public static synchronized SecurityThreadPoolExecutor globalPool() {
        if (globalPool == null) {
            int poolSize = Integer.parseInt(ConfigFactory.getProperty("thread_pool.global.pool_size", "10"));
            int queueSize = Integer.parseInt(ConfigFactory.getProperty("thread_pool.global.queue_size", "100000"));
            globalPool = ThreadUtils.newThreadPool(1, poolSize, 120, queueSize, "global-pool-%d");
            globalPool.setSecurityChecker(new SecurityChecker().ownerThread(ThreadUtils.addShutdownHook(globalPool::shutdown)));
        }
        return globalPool;
    }

    public static synchronized WheelTimer globalTimer() {
        if (globalTimer == null) {
            globalTimer = new WheelTimer(Integer.parseInt(ConfigFactory.getProperty("wheel_timer.global.duration", "1")), Integer.parseInt(ConfigFactory.getProperty("wheel_timer.global.wheel_size", "60")), Integer.parseInt(ConfigFactory.getProperty("wheel_timer.global.pool_size", "10")));
            globalTimer.getSecurityChecker().ownerThread(ThreadUtils.addShutdownHook(globalTimer::shutdown));
        }
        return globalTimer;
    }

    private ThreadUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

