/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.UnaryOperator;
import vip.justlive.oxygen.core.util.MoreObjects;
import vip.justlive.oxygen.core.util.Pair;

public class TokenParser {
    private static final char ESC = '\\';
    private final String openToken;
    private final String closeToken;
    private final UnaryOperator<String> textHandler;
    private final UnaryOperator<String> tokenHandler;

    public TokenParser(String openToken, String closeToken) {
        this(openToken, closeToken, UnaryOperator.identity(), UnaryOperator.identity());
    }

    public TokenParser(String openToken, String closeToken, UnaryOperator<String> tokenHandler) {
        this(openToken, closeToken, UnaryOperator.identity(), tokenHandler);
    }

    public String parse(String text) {
        return this.parse(text, this.tokenHandler);
    }

    public String parse(String text, UnaryOperator<String> tokenHandler) {
        return this.parse(text, this.textHandler, tokenHandler);
    }

    public String parse(String text, UnaryOperator<String> textHandler, UnaryOperator<String> tokenHandler) {
        MoreObjects.notNull(textHandler, "textHandler cannot be null");
        MoreObjects.notNull(tokenHandler, "tokenHandler cannot be null");
        ArrayList<Pair<String, Boolean>> statements = new ArrayList<Pair<String, Boolean>>(2);
        this.parse0(text, statements);
        StringBuilder sb = new StringBuilder();
        for (Pair pair : statements) {
            if (pair.getValue() != null && ((Boolean)pair.getValue()).booleanValue()) {
                sb.append((String)tokenHandler.apply((String)pair.getKey()));
                continue;
            }
            sb.append((String)textHandler.apply((String)pair.getKey()));
        }
        return sb.toString();
    }

    private void text(String text, List<Pair<String, Boolean>> statements) {
        statements.add(new Pair().setKey(text).setValue(false));
    }

    private void token(String text, List<Pair<String, Boolean>> statements) {
        statements.add(new Pair().setKey(text).setValue(true));
    }

    private void parse0(String text, List<Pair<String, Boolean>> statements) {
        if (text == null || text.isEmpty()) {
            return;
        }
        AtomicInteger start = new AtomicInteger(text.indexOf(this.openToken));
        if (start.get() == -1) {
            this.text(text, statements);
            return;
        }
        char[] chars = text.toCharArray();
        AtomicInteger index = new AtomicInteger(0);
        while (start.get() > -1) {
            this.searchExp(start, index, chars, text, statements);
        }
        if (index.get() < chars.length) {
            this.text(new String(chars, index.get(), chars.length - index.get()), statements);
        }
    }

    private void searchExp(AtomicInteger start, AtomicInteger index, char[] chars, String text, List<Pair<String, Boolean>> statements) {
        StringBuilder exp = new StringBuilder();
        if (start.get() > 0 && chars[start.get() - 1] == '\\') {
            this.text(new String(chars, index.get(), start.get() - index.get() - 1).concat(this.openToken), statements);
            index.set(start.get() + this.openToken.length());
        } else {
            this.text(new String(chars, index.get(), start.get() - index.get()), statements);
            index.set(start.get() + this.openToken.length());
            AtomicInteger end = new AtomicInteger(text.indexOf(this.closeToken, index.get()));
            this.searchCloseToken(end, index, chars, text, exp);
            if (end.get() > -1) {
                this.token(exp.toString(), statements);
            } else {
                this.text(new String(chars, start.get(), chars.length - start.get()), statements);
                index.set(chars.length);
            }
        }
        start.set(text.indexOf(this.openToken, index.get()));
    }

    private void searchCloseToken(AtomicInteger end, AtomicInteger index, char[] chars, String text, StringBuilder exp) {
        while (end.get() > -1) {
            if (end.get() > index.get() && chars[end.get() - 1] == '\\') {
                exp.append(chars, index.get(), end.get() - index.get() - 1).append(this.closeToken);
                index.set(end.get() + this.closeToken.length());
                end.set(text.indexOf(this.closeToken, index.get()));
                continue;
            }
            exp.append(chars, index.get(), end.get() - index.get());
            index.set(end.get() + this.closeToken.length());
            break;
        }
    }

    public TokenParser(String openToken, String closeToken, UnaryOperator<String> textHandler, UnaryOperator<String> tokenHandler) {
        this.openToken = openToken;
        this.closeToken = closeToken;
        this.textHandler = textHandler;
        this.tokenHandler = tokenHandler;
    }
}

