/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import vip.justlive.oxygen.core.util.JarFileInfo;
import vip.justlive.oxygen.core.util.MoreObjects;

public final class Urls {
    public static final String URL_PROTOCOL_FILE = "file";
    public static final String URL_PROTOCOL_JAR = "jar";
    public static final String URL_PROTOCOL_WAR = "war";
    public static final String URL_PROTOCOL_ZIP = "zip";
    public static final String URL_PROTOCOL_WSJAR = "wsjar";
    public static final String URL_PROTOCOL_VFSZIP = "vfszip";
    public static final String WAR_URL_SEPARATOR = "*/";
    public static final String JAR_URL_SEPARATOR = "!/";

    public static boolean isJarURL(URL url) {
        String protocol = url.getProtocol();
        return URL_PROTOCOL_JAR.equals(protocol) || URL_PROTOCOL_WAR.equals(protocol) || URL_PROTOCOL_ZIP.equals(protocol) || URL_PROTOCOL_VFSZIP.equals(protocol) || URL_PROTOCOL_WSJAR.equals(protocol);
    }

    public static URI toURI(String url) throws URISyntaxException {
        return new URI(url.replace(" ", "%20"));
    }

    public static URI toURI(URL url) throws URISyntaxException {
        return new URI(url.toString().replace(" ", "%20"));
    }

    public static String relativePath(String rootPath, String relative) {
        int last = rootPath.lastIndexOf("/");
        String newPath = rootPath;
        if (last > -1) {
            newPath = rootPath.substring(0, last);
            if (!relative.startsWith("/")) {
                newPath = newPath + "/";
            }
            newPath = newPath + relative;
        }
        return newPath;
    }

    public static String cutRootPath(String path) {
        String usePath = path;
        if (usePath.startsWith("/")) {
            usePath = usePath.substring("/".length());
        }
        return usePath;
    }

    public static String concat(String parent, String child) {
        MoreObjects.notNull(parent);
        MoreObjects.notNull(child);
        StringBuilder sb = new StringBuilder(parent);
        if (parent.endsWith("/") && child.startsWith("/")) {
            sb.deleteCharAt(sb.length() - 1);
        }
        if (!parent.endsWith("/") && !child.startsWith("/")) {
            sb.append("/");
        }
        sb.append(child);
        if (sb.indexOf("/") != 0) {
            sb.insert(0, "/");
        }
        if (sb.length() > 1 && sb.lastIndexOf("/") == sb.length() - 1) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static JarFile getJarFile(String jarFileUrl) throws IOException {
        if (jarFileUrl.startsWith("file:")) {
            try {
                return new JarFile(Urls.toURI(jarFileUrl).getSchemeSpecificPart());
            }
            catch (URISyntaxException ex) {
                return new JarFile(jarFileUrl.substring("file:".length()));
            }
        }
        return new JarFile(jarFileUrl);
    }

    public static JarFileInfo getJarFileInfo(URL url) throws IOException {
        String rootEntryPath;
        String jarFileUrl;
        JarFile jarFile;
        URLConnection con = url.openConnection();
        if (con instanceof JarURLConnection) {
            JarURLConnection jarCon = (JarURLConnection)con;
            jarFile = jarCon.getJarFile();
            jarFileUrl = jarCon.getJarFileURL().toExternalForm();
            JarEntry jarEntry = jarCon.getJarEntry();
            rootEntryPath = jarEntry != null ? jarEntry.getName() : "";
        } else {
            String urlFile = url.getFile();
            int separatorLength = WAR_URL_SEPARATOR.length();
            int separatorIndex = urlFile.indexOf(WAR_URL_SEPARATOR);
            if (separatorIndex == -1) {
                separatorIndex = urlFile.indexOf(JAR_URL_SEPARATOR);
                separatorLength = JAR_URL_SEPARATOR.length();
            }
            if (separatorIndex != -1) {
                jarFileUrl = urlFile.substring(0, separatorIndex);
                rootEntryPath = urlFile.substring(separatorIndex + separatorLength);
                jarFile = Urls.getJarFile(jarFileUrl);
            } else {
                jarFile = new JarFile(urlFile);
                jarFileUrl = urlFile;
                rootEntryPath = "";
            }
        }
        return new JarFileInfo(jarFile, jarFileUrl, rootEntryPath);
    }

    public static String urlEncode(String s) {
        return Urls.urlEncode(s, StandardCharsets.UTF_8);
    }

    public static String urlEncode(String s, Charset charset) {
        try {
            return URLEncoder.encode(s, charset.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return s;
        }
    }

    public static String urlDecode(String s) {
        return Urls.urlDecode(s, StandardCharsets.UTF_8);
    }

    public static String urlDecode(String s, Charset charset) {
        try {
            return URLDecoder.decode(s, charset.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return s;
        }
    }

    private Urls() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

