/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.util.json;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vip.justlive.oxygen.core.util.ServiceLoaderUtils;
import vip.justlive.oxygen.core.util.json.codec.ArraySerializer;
import vip.justlive.oxygen.core.util.json.codec.AtomicArraySerializer;
import vip.justlive.oxygen.core.util.json.codec.BeanSerializer;
import vip.justlive.oxygen.core.util.json.codec.IterableSerializer;
import vip.justlive.oxygen.core.util.json.codec.MapSerializer;
import vip.justlive.oxygen.core.util.json.codec.ReferenceSerializer;
import vip.justlive.oxygen.core.util.json.codec.Serializer;

public class JsonWriter {
    private static final Logger log = LoggerFactory.getLogger(JsonWriter.class);
    private final List<Serializer> serializers = new ArrayList<Serializer>();

    public JsonWriter() {
        this.serializers.addAll(ServiceLoaderUtils.loadServices(Serializer.class));
        this.serializers.add(new BeanSerializer(this.serializers));
        this.serializers.add(new MapSerializer(this.serializers));
        this.serializers.add(new IterableSerializer(this.serializers));
        this.serializers.add(new ArraySerializer(this.serializers));
        this.serializers.add(new AtomicArraySerializer(this.serializers));
        this.serializers.add(new ReferenceSerializer(this.serializers));
        Collections.sort(this.serializers);
    }

    public void addSerializer(Serializer serializer) {
        if (this.serializers.contains(serializer)) {
            return;
        }
        this.serializers.add(serializer);
        Collections.sort(this.serializers);
    }

    public String toJson(Object value) {
        StringBuilder buf = new StringBuilder();
        Serializer serializer = Serializer.lookup(this.serializers, value);
        if (serializer != null) {
            serializer.serialize(value, buf);
            return buf.toString();
        }
        log.warn("value {} can not serialize to json", value);
        return buf.toString();
    }

    public List<Serializer> getSerializers() {
        return this.serializers;
    }
}

