/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.util.json.codec;

import java.util.List;
import vip.justlive.oxygen.core.util.json.codec.Serializer;

public class IterableSerializer
implements Serializer {
    private final List<Serializer> serializers;

    @Override
    public boolean supported(Class<?> type, Object value) {
        return value != null && Iterable.class.isAssignableFrom(type);
    }

    @Override
    public void serialize(Object value, StringBuilder buf) {
        Iterable iterable = (Iterable)value;
        buf.append('[');
        this.processIterable(iterable, buf);
        buf.append(']');
    }

    private void processIterable(Iterable<?> iterable, StringBuilder buf) {
        boolean del = false;
        for (Object object : iterable) {
            Serializer serializer = Serializer.lookup(this.serializers, object);
            if (serializer == null) continue;
            serializer.serialize(object, buf);
            buf.append(',');
            del = true;
        }
        if (del) {
            buf.deleteCharAt(buf.length() - 1);
        }
    }

    public IterableSerializer(List<Serializer> serializers) {
        this.serializers = serializers;
    }
}

