/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.util.json.codec;

import java.lang.ref.Reference;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import vip.justlive.oxygen.core.util.json.codec.Serializer;

public class ReferenceSerializer
implements Serializer {
    private final List<Serializer> serializers;

    @Override
    public boolean supported(Class<?> type, Object value) {
        return Reference.class.isAssignableFrom(type) || type == AtomicReference.class;
    }

    @Override
    public void serialize(Object value, StringBuilder buf) {
        Object obj = value instanceof AtomicReference ? ((AtomicReference)value).get() : ((Reference)value).get();
        Serializer serializer = Serializer.lookup(this.serializers, obj);
        if (serializer != null) {
            serializer.serialize(obj, buf);
        }
    }

    public ReferenceSerializer(List<Serializer> serializers) {
        this.serializers = serializers;
    }
}

