/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.util.json.codec;

import vip.justlive.oxygen.core.util.json.codec.Serializer;

public class StringSerializer
implements Serializer {
    @Override
    public boolean supported(Class<?> type, Object value) {
        return CharSequence.class.isAssignableFrom(type);
    }

    @Override
    public void serialize(Object value, StringBuilder buf) {
        String string = value.toString();
        buf.append('\"');
        int len = string.length();
        block8: for (int i = 0; i < len; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\b': {
                    buf.append("\\b");
                    continue block8;
                }
                case '\t': {
                    buf.append("\\t");
                    continue block8;
                }
                case '\n': {
                    buf.append("\\n");
                    continue block8;
                }
                case '\f': {
                    buf.append("\\f");
                    continue block8;
                }
                case '\r': {
                    buf.append("\\r");
                    continue block8;
                }
                case '\"': 
                case '\\': {
                    buf.append('\\').append(c);
                    continue block8;
                }
                default: {
                    if (c < ' ') {
                        String t = "000" + Integer.toHexString(c);
                        buf.append("\\u").append(t, 0, t.length() - 4);
                        continue block8;
                    }
                    buf.append(c);
                }
            }
        }
        buf.append('\"');
    }
}

