/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.util.json.codec;

import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.time.ZoneId;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Currency;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.regex.Pattern;
import vip.justlive.oxygen.core.util.ClassUtils;
import vip.justlive.oxygen.core.util.json.codec.Serializer;

public class ToStringSerializer
implements Serializer {
    private static final List<Class<?>> NON_WRAPPED = new ArrayList();
    private static final List<Class<?>> WRAPPED = new ArrayList();

    public static void addNonWrappedType(Class<?> type) {
        if (!NON_WRAPPED.contains(type)) {
            NON_WRAPPED.add(type);
        }
    }

    public static void addWrappedType(Class<?> type) {
        if (!WRAPPED.contains(type)) {
            WRAPPED.add(type);
        }
    }

    @Override
    public int order() {
        return 100;
    }

    @Override
    public boolean supported(Class<?> type, Object value) {
        return value != null && (this.isIn(type, NON_WRAPPED) || this.isIn(type, WRAPPED));
    }

    @Override
    public void serialize(Object value, StringBuilder buf) {
        boolean wrapper = this.isIn(value.getClass(), WRAPPED);
        if (wrapper) {
            buf.append('\"');
        }
        buf.append(value.toString());
        if (wrapper) {
            buf.append('\"');
        }
    }

    private boolean isIn(Class<?> type, List<Class<?>> types) {
        if (types.contains(type)) {
            return true;
        }
        for (Class<?> wrap : types) {
            if (!wrap.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    static {
        ToStringSerializer.addNonWrappedType(Number.class);
        ClassUtils.allPrimitiveTypes().forEach(ToStringSerializer::addNonWrappedType);
        ClassUtils.allWrapperTypes().forEach(ToStringSerializer::addNonWrappedType);
        Arrays.asList(Temporal.class, Charset.class, Pattern.class, Locale.class, URI.class, URL.class, UUID.class, Enum.class, Currency.class, ZoneId.class).forEach(ToStringSerializer::addWrappedType);
    }
}

