/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.oxygen.core.util.retry;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import vip.justlive.oxygen.core.util.retry.Attempt;
import vip.justlive.oxygen.core.util.retry.Retryer;

public class AsyncRetryer<T>
extends Retryer<T> {
    ScheduledExecutorService scheduledExecutorService;
    long waitTime;

    public CompletableFuture<T> callAsync(Callable<T> callable) {
        CompletableFuture future = new CompletableFuture();
        this.scheduledExecutorService.submit(this.createRunner(callable, System.currentTimeMillis(), 1L, future));
        return future;
    }

    private Runnable createRunner(Callable<T> callable, long startTime, long attemptNumbers, CompletableFuture<T> future) {
        return () -> {
            Attempt attempt = this.attempt(callable, attemptNumbers, startTime);
            this.retryListeners.forEach(listener -> listener.accept(attempt));
            if (!this.retryPredicate.test(attempt)) {
                if (attempt.hasException()) {
                    this.failListeners.forEach(listener -> listener.accept(attempt));
                    future.completeExceptionally(attempt.getException());
                } else {
                    this.successListeners.forEach(listener -> listener.accept(attempt));
                    future.complete(attempt.getResult());
                }
            }
            if (future.isDone()) {
                return;
            }
            if (this.stopPredicate.test(attempt)) {
                this.failListeners.forEach(listener -> listener.accept(attempt));
                future.completeExceptionally(attempt.getException());
            }
            this.scheduledExecutorService.schedule(this.createRunner(callable, startTime, attemptNumbers + 1L, future), this.waitTime, TimeUnit.MILLISECONDS);
        };
    }
}

